/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo;

import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo.BaseGetFeatureInfoFixture;
import de.latlon.ets.wms13.core.domain.BoundingBox;
import de.latlon.ets.wms13.core.domain.Dimension;
import de.latlon.ets.wms13.core.domain.LayerInfo;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.uom.UomMatcher;
import de.latlon.ets.wms13.core.uom.UomMatcherFromFile;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import de.latlon.ets.wms13.core.util.request.WmsRequestBuilder;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPException;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetFeatureInfoUomTest
extends BaseGetFeatureInfoFixture {
    private final UomMatcher uomMatcher = new UomMatcherFromFile();

    @DataProvider(name="layerInfoWithDimension")
    public Object[][] provideLayerInfoWithDimension(ITestContext testContext) {
        this.initBaseFixture(testContext);
        ArrayList<LayerInfo> layerInfoWithDimension = new ArrayList<LayerInfo>();
        for (LayerInfo layerInfo : this.layerInfo) {
            if (layerInfo.getDimensions().isEmpty() || !layerInfo.isQueryable()) continue;
            layerInfoWithDimension.add(layerInfo);
        }
        Object[][] resultingLayerInfo = new Object[layerInfoWithDimension.size()][];
        for (LayerInfo layerInfo : layerInfoWithDimension) {
            resultingLayerInfo[layerInfoWithDimension.indexOf((Object)layerInfo)] = new Object[]{layerInfo};
        }
        return resultingLayerInfo;
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.6, S.22, Requirement 32", dataProvider="layerInfoWithDimension")
    public void wmsGetFeatureInfoInfoUnitOfMeasureOfDimensionalData(LayerInfo layerInfoWithDimension) throws SOAPException, XPathExpressionException, XPathFactoryConfigurationException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        BoundingBox bbox = WmsRequestBuilder.findBoundingBox(layerInfoWithDimension);
        String layerName = layerInfoWithDimension.getLayerName();
        this.reqEntity.addKvp("LAYERS", layerName);
        this.reqEntity.addKvp("STYLES", "");
        this.reqEntity.addKvp("CRS", bbox.getCrs());
        this.reqEntity.addKvp("BBOX", bbox.getBboxAsString());
        this.reqEntity.addKvp("QUERY_LAYERS", layerName);
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        NodeList featureMemberNodes = this.parseFeatureMembers(layerName);
        this.assertResponseContainsUnitOfMeasure(layerInfoWithDimension, featureMemberNodes);
    }

    private NodeList parseFeatureMembers(String layerName) throws XPathFactoryConfigurationException, XPathExpressionException {
        NodeList featureMemberNodes = this.parseFeatureMemberNodes(this.rspEntity);
        if (featureMemberNodes.getLength() == 0) {
            throw new SkipException("Layer " + layerName + " does not contain any results in response of GetFeatureInfo.");
        }
        return featureMemberNodes;
    }

    private void assertResponseContainsUnitOfMeasure(LayerInfo layerInfoWithDimension, NodeList featureMemberNodes) throws XPathExpressionException, XPathFactoryConfigurationException {
        for (Dimension dimension : layerInfoWithDimension.getDimensions()) {
            String dimensionName = dimension.getName();
            for (int memberIndex = 0; memberIndex < featureMemberNodes.getLength(); ++memberIndex) {
                Node featureMember = featureMemberNodes.item(memberIndex);
                if (!this.containsDimension(dimensionName, featureMember)) continue;
                this.assertUom(dimensionName, featureMember);
            }
        }
    }

    private void assertUom(String dimensionName, Node featureMember) throws XPathExpressionException, XPathFactoryConfigurationException, AssertionError {
        String expression = String.format("//*[local-name() = '%s_uom']", dimensionName);
        String returnedUom = (String)this.createXPath().evaluate(expression, featureMember, XPathConstants.STRING);
        if (returnedUom == null || returnedUom.equals("")) {
            throw new AssertionError((Object)("Missing UoM for dimension " + dimensionName + "!"));
        }
        Assert.assertTrue((boolean)this.uomMatcher.isExpectedUoM(returnedUom), (String)("UoM '" + returnedUom + "' of dimension " + dimensionName + " is not expected!"));
    }

    private boolean containsDimension(String dimensionName, Node featureMember) throws XPathExpressionException, XPathFactoryConfigurationException {
        String expression = String.format("//*[local-name() = '%s']", dimensionName);
        return (Boolean)this.createXPath().evaluate(expression, featureMember, XPathConstants.BOOLEAN);
    }
}

