/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getmap;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.crs.CrsMatcher;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getmap.BaseGetMapFixture;
import de.latlon.ets.wms13.core.domain.BoundingBox;
import de.latlon.ets.wms13.core.domain.LayerInfo;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class GetMapLayerCrsTest
extends BaseGetMapFixture {
    private static final CrsMatcher CRS_MATCHER = new CrsMatcher();
    private static final String REQUEST_FORMAT = "image/png";

    @DataProvider(name="layerNodes")
    public Object[][] parseLayerNodes(ITestContext testContext) throws XPathFactoryConfigurationException, XPathExpressionException {
        Object[][] layers = new Object[this.layerInfo.size()][];
        for (int layerIndex = 0; layerIndex < this.layerInfo.size(); ++layerIndex) {
            LayerInfo layer = (LayerInfo)this.layerInfo.get(layerIndex);
            layers[layerIndex] = new Object[]{layer};
        }
        return layers;
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.4.2., S.11, Requirement 6", dataProvider="layerNodes")
    public void wmsGetMapLayerCrs_Mandatory_CRS_84_Supported(LayerInfo layer) {
        String crs = "CRS:84";
        String bbox = this.findBboxOrSkipTestIfCrsIsNotSupported(layer, crs);
        String layerName = layer.getLayerName();
        this.reqEntity.addKvp("LAYERS", layerName);
        this.reqEntity.addKvp("CRS", crs);
        this.reqEntity.addKvp("BBOX", bbox);
        this.reqEntity.addKvp("FORMAT", REQUEST_FORMAT);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        this.storeResponseImage(rsp, "Requirement6", "Mandatory_CRS_84_Supported_By_Layer_" + layerName, REQUEST_FORMAT);
        ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
        ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)REQUEST_FORMAT);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.4.2., S.11, Requirement 6", dataProvider="layerNodes")
    public void wmsGetMapLayerCrs_Mandatory_EPSG_4326_Supported(LayerInfo layer) {
        String crs = "EPSG:4326";
        String bbox = this.findBboxOrSkipTestIfCrsIsNotSupported(layer, crs);
        String layerName = layer.getLayerName();
        this.reqEntity.addKvp("LAYERS", layerName);
        this.reqEntity.addKvp("CRS", crs);
        this.reqEntity.addKvp("BBOX", bbox);
        this.reqEntity.addKvp("FORMAT", REQUEST_FORMAT);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        this.storeResponseImage(rsp, "Requirement6", "Mandatory_EPSG_4326_Supported_By_Layer_" + layerName, REQUEST_FORMAT);
        ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
        ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)REQUEST_FORMAT);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.4.2., S.11, Requirement 6", dataProvider="layerNodes")
    public void wmsGetMapLayerCrs_Mandatory_EPSG_3395_Supported(LayerInfo layer) {
        String crs = "EPSG:3395";
        String bbox = this.findBboxOrSkipTestIfCrsIsNotSupported(layer, crs);
        String layerName = layer.getLayerName();
        this.reqEntity.addKvp("LAYERS", layerName);
        this.reqEntity.addKvp("CRS", crs);
        this.reqEntity.addKvp("BBOX", bbox);
        this.reqEntity.addKvp("FORMAT", REQUEST_FORMAT);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
        Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        this.storeResponseImage(rsp, "Requirement6", "Mandatory_EPSG_3395_Supported_By_Layer_" + layerName, REQUEST_FORMAT);
        ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
        ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)REQUEST_FORMAT);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.4.2., S.11, Requirement 6", dataProvider="layerNodes")
    public void wmsGetMapLayerCrs_Conditional_Supported(LayerInfo layer) {
        List<String> conditionalExpectedCrs = CRS_MATCHER.retrieveOverlappingCrs(layer.getGeographicBbox());
        for (String crs : conditionalExpectedCrs) {
            String bbox = this.findBboxOrSkipTestIfCrsIsNotSupported(layer, crs);
            String layerName = layer.getLayerName();
            this.reqEntity.addKvp("LAYERS", layerName);
            this.reqEntity.addKvp("CRS", crs);
            this.reqEntity.addKvp("BBOX", bbox);
            this.reqEntity.addKvp("FORMAT", REQUEST_FORMAT);
            URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetMap", ProtocolBinding.GET);
            Response rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
            Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
            this.storeResponseImage(rsp, "Requirement6", "Conditional_" + crs.replace(":", "_") + "_Supported_By_Layer_" + layerName, REQUEST_FORMAT);
            ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
            ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)REQUEST_FORMAT);
        }
    }

    private String findBboxOrSkipTestIfCrsIsNotSupported(LayerInfo layer, String crs) {
        for (BoundingBox bbox : layer.getBboxes()) {
            if (!crs.equals(bbox.getCrs())) continue;
            return bbox.getBboxAsString();
        }
        throw new SkipException("Layer " + layer.getLayerName() + " does not support CRS " + crs + ", tests are skipped!");
    }
}

