/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.domain.dimension.date;

import de.latlon.ets.wms13.core.domain.dimension.RequestableDimension;
import jakarta.xml.bind.DatatypeConverter;
import java.util.Calendar;
import java.util.Random;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class DateTimeDimensionInterval
implements RequestableDimension {
    private static final Random RANDOM = new Random();
    private final DateTime min;
    private final DateTime max;
    private final Period resolution;

    public DateTimeDimensionInterval(DateTime min, DateTime max, Period resolution) {
        this.min = min;
        this.max = max;
        this.resolution = resolution;
    }

    @Override
    public String retrieveRequestableValue() {
        if (this.resolution == null) {
            return this.randomDateInInterval();
        }
        int steps = this.calculateStepsBetween();
        if (steps <= 0) {
            return this.asString(this.min);
        }
        int stepsToGo = RANDOM.nextInt(steps);
        DateTime withRandomPeriodAdded = this.min.withPeriodAdded((ReadablePeriod)this.resolution, stepsToGo);
        return this.asString(withRandomPeriodAdded);
    }

    public DateTime getMin() {
        return this.min;
    }

    public DateTime getMax() {
        return this.max;
    }

    public Period getResolution() {
        return this.resolution;
    }

    private int calculateStepsBetween() {
        int steps = 0;
        DateTime current = this.min;
        while (current.isBefore((ReadableInstant)this.max)) {
            current = current.plus((ReadablePeriod)this.resolution);
            ++steps;
        }
        return steps;
    }

    private String asString(DateTime withRandomPeriodAdded) {
        return DatatypeConverter.printDateTime((Calendar)withRandomPeriodAdded.toGregorianCalendar());
    }

    private String randomDateInInterval() {
        long minMillis = this.min.getMillis();
        long maxMillis = this.max.getMillis();
        long diffMillis = maxMillis - minMillis;
        long nextTime = minMillis + this.nextLong(diffMillis);
        return this.asString(new DateTime(nextTime));
    }

    private long nextLong(long n) {
        long val;
        long bits;
        while ((bits = RANDOM.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }
}

