/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.core.util.soap;

import de.latlon.ets.core.util.TestSuiteLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class SoapUtils {
    private SoapUtils() {
    }

    public static Source readPayloadFromFile(InputStream resourceAsStream) {
        if (resourceAsStream == null) {
            throw new IllegalArgumentException("InputStream must not be null");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(resourceAsStream);
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.SEVERE, "Failed to parse document", e);
        }
        catch (IOException | SAXException e) {
            TestSuiteLogger.log(Level.SEVERE, "Failed to read from stream", e);
        }
        return new DOMSource(document);
    }

    public static SOAPPart convertToSoapPart(Source source) throws SOAPException {
        MessageFactory factory = MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
        SOAPMessage message = factory.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        soapPart.setContent(source);
        return soapPart;
    }
}

