/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.assertion.WmsAssertion;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.net.URI;
import java.util.List;
import java.util.Random;
import javax.xml.soap.SOAPException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class GetCapabilitiesRequestParameterTest
extends AbstractBaseGetCapabilitiesFixture {
    private static final Random RANDOM = new Random();

    @BeforeMethod
    public void clearRequest() {
        this.reqEntity.removeKvp("FORMAT");
        this.reqEntity.removeKvp("UPDATESEQUENCE");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.1., S.12, Requirement 8")
    public void wmsCapabilitiesOutputFormatParameterSupported() throws SOAPException {
        List<String> supportedFormats = ServiceMetadataUtils.parseSupportedFormats(this.wmsCapabilities, "GetCapabilities");
        if (supportedFormats.size() > 0) {
            String format = this.retrieveRandomFormat(supportedFormats);
            this.reqEntity.addKvp("FORMAT", format);
            URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetCapabilities", ProtocolBinding.GET);
            ClientResponse rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
            Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
            ETSAssert.assertContentType(rsp.getHeaders(), format);
            if ("text/xml".equals(format)) {
                Document reqEntity = rsp.getEntity(Document.class);
                WmsAssertion.assertSimpleWMSCapabilities(reqEntity);
                WmsAssertion.assertVersion130(reqEntity);
            }
        }
    }

    private String retrieveRandomFormat(List<String> supportedFormats) {
        int index = RANDOM.nextInt(supportedFormats.size());
        return supportedFormats.get(index);
    }
}

