/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.util.interactive;

import de.latlon.ets.core.util.URIUtils;
import de.latlon.ets.wms13.core.client.WmsKvpRequest;
import de.latlon.ets.wms13.core.domain.LayerInfo;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import de.latlon.ets.wms13.core.util.request.WmsRequestBuilder;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.w3c.dom.Document;

public final class InteractiveTestUtils {
    private static final String UNKNOWN_LAYER_FOR_TESTING = "UNKNOWN_LAYER_FOR_TESTING";

    private InteractiveTestUtils() {
    }

    public static String retrieveGetFeatureInfoRequest(String wmsCapabilitiesUrl) {
        Document wmsCapabilities = InteractiveTestUtils.readCapabilities(wmsCapabilitiesUrl);
        URI getFeatureInfoEndpoint = ServiceMetadataUtils.getOperationEndpoint(wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        List<LayerInfo> layerInfos = ServiceMetadataUtils.parseLayerInfo(wmsCapabilities);
        WmsKvpRequest getFeatureInfoRequest = WmsRequestBuilder.buildGetFeatureInfoRequest(wmsCapabilities, layerInfos);
        return InteractiveTestUtils.createUri(getFeatureInfoEndpoint, getFeatureInfoRequest);
    }

    public static String retrieveInvalidGetFeatureInfoRequest(String wmsCapabilitiesUrl) {
        Document wmsCapabilities = InteractiveTestUtils.readCapabilities(wmsCapabilitiesUrl);
        URI getFeatureInfoEndpoint = ServiceMetadataUtils.getOperationEndpoint(wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        List<LayerInfo> layerInfos = ServiceMetadataUtils.parseLayerInfo(wmsCapabilities);
        WmsKvpRequest getFeatureInfoRequest = WmsRequestBuilder.buildGetFeatureInfoRequest(wmsCapabilities, layerInfos);
        getFeatureInfoRequest.addKvp("LAYERS", UNKNOWN_LAYER_FOR_TESTING);
        getFeatureInfoRequest.addKvp("QUERY_LAYERS", UNKNOWN_LAYER_FOR_TESTING);
        return InteractiveTestUtils.createUri(getFeatureInfoEndpoint, getFeatureInfoRequest);
    }

    public static String retrieveInvalidGetMapRequest(String wmsCapabilitiesUrl) {
        Document wmsCapabilities = InteractiveTestUtils.readCapabilities(wmsCapabilitiesUrl);
        URI getFeatureInfoEndpoint = ServiceMetadataUtils.getOperationEndpoint(wmsCapabilities, "GetMap", ProtocolBinding.GET);
        List<LayerInfo> layerInfos = ServiceMetadataUtils.parseLayerInfo(wmsCapabilities);
        WmsKvpRequest getFeatureInfoRequest = WmsRequestBuilder.buildGetMapRequest(wmsCapabilities, layerInfos);
        getFeatureInfoRequest.addKvp("LAYERS", UNKNOWN_LAYER_FOR_TESTING);
        return InteractiveTestUtils.createUri(getFeatureInfoEndpoint, getFeatureInfoRequest);
    }

    private static String createUri(URI getFeatureInfoEndpoint, WmsKvpRequest getFeatureInfoRequest) {
        String queryString = getFeatureInfoRequest.asQueryString();
        URI requestURI = UriBuilder.fromUri(getFeatureInfoEndpoint).replaceQuery(queryString).build(new Object[0]);
        return requestURI.toString();
    }

    private static Document readCapabilities(String wmsCapabilitiesUrl) {
        URI wmsURI = URI.create(wmsCapabilitiesUrl);
        Document doc = null;
        try {
            doc = URIUtils.resolveURIAsDocument(wmsURI);
            if (!doc.getDocumentElement().getLocalName().equals("WMS_Capabilities")) {
                throw new RuntimeException("Did not receive WMS capabilities document: " + doc.getDocumentElement().getNodeName());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse resource located at " + wmsURI, ex);
        }
        return doc;
    }
}

