/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.util.request;

import de.latlon.ets.wms13.core.client.WmsKvpRequest;
import de.latlon.ets.wms13.core.domain.BoundingBox;
import de.latlon.ets.wms13.core.domain.LayerInfo;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.testng.Assert;
import org.w3c.dom.Document;

public final class WmsRequestBuilder {
    private static final Random RANDOM = new Random();
    private static final List<String> TRANSPARENT_IMG_FORMATS = Arrays.asList("image/png", "image/gif");

    private WmsRequestBuilder() {
    }

    public static WmsKvpRequest buildGetFeatureInfoRequest(Document wmsCapabilities, List<LayerInfo> layerInfos) {
        String format = WmsRequestBuilder.getSupportedFormat(wmsCapabilities, "GetFeatureInfo");
        return WmsRequestBuilder.buildGetFeatureInfoRequest(wmsCapabilities, layerInfos, format);
    }

    public static WmsKvpRequest buildGetFeatureInfoRequest(Document wmsCapabilities, List<LayerInfo> layerInfos, String format) {
        boolean isFormatSupported = ServiceMetadataUtils.parseSupportedFormats(wmsCapabilities, "GetFeatureInfo").contains(format);
        Assert.assertTrue(isFormatSupported, "The requested format is not supported for GetFEatureInfo requests.");
        return WmsRequestBuilder.buildGetFeatureInfoRequestWithFormat(layerInfos, format);
    }

    public static WmsKvpRequest buildGetMapRequest(Document wmsCapabilities, List<LayerInfo> layerInfos) {
        WmsKvpRequest reqEntity = new WmsKvpRequest();
        reqEntity.addKvp("service", "WMS");
        reqEntity.addKvp("version", "1.3.0");
        reqEntity.addKvp("request", "GetMap");
        LayerInfo layerInfo = WmsRequestBuilder.findSuitableLayerInfo(layerInfos);
        Assert.assertNotNull(layerInfo, "Could not find suitable layer for GetMap request.");
        String format = WmsRequestBuilder.getSupportedFormat(wmsCapabilities, "GetMap");
        Assert.assertNotNull(format, "Could not find request format for GetMap request.");
        reqEntity.addKvp("LAYERS", layerInfo.getLayerName());
        reqEntity.addKvp("STYLES", "");
        BoundingBox bbox = WmsRequestBuilder.findBoundingBox(layerInfo);
        reqEntity.addKvp("CRS", bbox.getCrs());
        reqEntity.addKvp("BBOX", bbox.getBboxAsString());
        reqEntity.addKvp("WIDTH", "100");
        reqEntity.addKvp("HEIGHT", "100");
        reqEntity.addKvp("FORMAT", format);
        return reqEntity;
    }

    private static WmsKvpRequest buildGetFeatureInfoRequestWithFormat(List<LayerInfo> layerInfos, String format) {
        WmsKvpRequest reqEntity = new WmsKvpRequest();
        reqEntity.addKvp("service", "WMS");
        reqEntity.addKvp("version", "1.3.0");
        reqEntity.addKvp("request", "GetFeatureInfo");
        LayerInfo layerInfo = WmsRequestBuilder.findSuitableLayerInfo(layerInfos);
        Assert.assertNotNull(layerInfo, "Could not find suitable layer for GetMap requests.");
        Assert.assertNotNull(format, "Could not find request format for GetFeatureInfo.");
        String layerName = layerInfo.getLayerName();
        BoundingBox bbox = WmsRequestBuilder.findBoundingBox(layerInfo);
        reqEntity.addKvp("LAYERS", layerName);
        reqEntity.addKvp("STYLES", "");
        reqEntity.addKvp("CRS", bbox.getCrs());
        reqEntity.addKvp("BBOX", bbox.getBboxAsString());
        reqEntity.addKvp("WIDTH", "1");
        reqEntity.addKvp("HEIGHT", "1");
        reqEntity.addKvp("QUERY_LAYERS", layerName);
        reqEntity.addKvp("I", "0");
        reqEntity.addKvp("J", "0");
        reqEntity.addKvp("INFO_FORMAT", format);
        return reqEntity;
    }

    public static String getSupportedFormat(Document wmsCapabilities, String opName) {
        List<String> supportedFormats = ServiceMetadataUtils.parseSupportedFormats(wmsCapabilities, opName);
        if (supportedFormats.size() > 0) {
            int randomIndex = RANDOM.nextInt(supportedFormats.size());
            return supportedFormats.get(randomIndex);
        }
        return null;
    }

    public static String getSupportedTransparentFormat(Document wmsCapabilities, String opName) {
        List<String> supportedFormats = ServiceMetadataUtils.parseSupportedFormats(wmsCapabilities, opName);
        for (String transparentFormat : TRANSPARENT_IMG_FORMATS) {
            if (!supportedFormats.contains(transparentFormat)) continue;
            return transparentFormat;
        }
        return null;
    }

    public static BoundingBox findBoundingBox(LayerInfo layerInfo) {
        List<BoundingBox> bboxes = layerInfo.getBboxes();
        int randomIndex = RANDOM.nextInt(bboxes.size());
        return bboxes.get(randomIndex);
    }

    private static LayerInfo findSuitableLayerInfo(List<LayerInfo> layerInfos) {
        ArrayList<LayerInfo> shuffledLayerInfos = new ArrayList<LayerInfo>(layerInfos);
        Collections.shuffle(shuffledLayerInfos);
        for (LayerInfo layerInfo : shuffledLayerInfos) {
            if (!WmsRequestBuilder.layerHasBboxes(layerInfo) || !WmsRequestBuilder.layerIsQueryable(layerInfo)) continue;
            return layerInfo;
        }
        return null;
    }

    private static boolean layerIsQueryable(LayerInfo layerInfo) {
        return layerInfo.isQueryable();
    }

    private static boolean layerHasBboxes(LayerInfo layerInfo) {
        return layerInfo.getBboxes().size() > 0;
    }
}

