/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getfeatureinfo.BaseGetFeatureInfoFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.soap.SOAPException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class GetFeatureInfoOutputFormatTest
extends BaseGetFeatureInfoFixture {
    @BeforeMethod
    public void clearRequest() {
        this.reqEntity.removeKvp("INFO_FORMAT");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3")
    public void wmsCapabilitiesOutputFormatTextXmlSupported() throws SOAPException {
        String xPathXml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetFeatureInfo/wms:Format/text() = 'text/xml'";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wmsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3")
    public void wmsCapabilitiesOutputFormatTextHtmlSupported() throws SOAPException {
        String xPathHtml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetFeatureInfo/wms:Format/text() = 'text/html'";
        ETSAssert.assertXPath((String)xPathHtml, (Node)this.wmsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3", dependsOnMethods={"wmsCapabilitiesOutputFormatTextXmlSupported"})
    public void wmsGetFeatureInfoOutputFormatTextXmlSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        this.reqEntity.addKvp("INFO_FORMAT", "text/xml");
        ClientResponse rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)"text/xml");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3", dependsOnMethods={"wmsCapabilitiesOutputFormatTextHtmlSupported"})
    public void wmsGetFeatureInfoOutputFormatTextHtmlSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        this.reqEntity.addKvp("INFO_FORMAT", "text/html");
        ClientResponse rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)"text/html");
    }
}

