/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.core;

import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.executors.testng.TestNGExecutor;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import de.latlon.ets.core.util.TestSuiteLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractTestNGController
implements TestSuiteController {
    private TestRunExecutor executor;
    private Properties etsProperties = new Properties();

    public AbstractTestNGController() {
        this(new File(System.getProperty("user.home")).toURI().toString());
    }

    public AbstractTestNGController(String outputDirUri) {
        InputStream is = this.getClass().getResourceAsStream("ets.properties");
        try {
            this.etsProperties.load(is);
        }
        catch (IOException ex) {
            TestSuiteLogger.log(Level.WARNING, "Unable to load ets.properties. " + ex.getMessage());
        }
        URL tngSuite = this.getTestNgConfiguration();
        File resultsDir = new File(URI.create(outputDirUri));
        TestSuiteLogger.log(Level.CONFIG, "Using TestNG config: " + tngSuite);
        TestSuiteLogger.log(Level.INFO, "Using outputDirPath: " + resultsDir.getAbsolutePath());
        this.executor = new TestNGExecutor(tngSuite.toString(), resultsDir.getAbsolutePath(), false);
    }

    public String getCode() {
        return this.etsProperties.getProperty("ets-code");
    }

    public String getVersion() {
        return this.etsProperties.getProperty("ets-version");
    }

    public String getTitle() {
        return this.etsProperties.getProperty("ets-title");
    }

    public Source doTestRun(Document testRunArgs) throws Exception {
        this.validateTestRunArgs(testRunArgs);
        return this.executor.execute(testRunArgs);
    }

    void validateTestRunArgs(Document testRunArgs) throws IllegalArgumentException {
        if (null == testRunArgs || !testRunArgs.getDocumentElement().getNodeName().equals("properties")) {
            throw new IllegalArgumentException("Input is not an XML properties document.");
        }
        NodeList entries = testRunArgs.getDocumentElement().getElementsByTagName("entry");
        if (entries.getLength() == 0) {
            throw new IllegalArgumentException("No test run arguments found.");
        }
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            args.put(entry.getAttribute("key"), entry.getTextContent());
        }
        this.validateTestRunArgs(args);
    }

    protected abstract void validateTestRunArgs(Map<String, String> var1);

    protected abstract URL getTestNgConfiguration();

    protected static File findXmlArgs(String[] args) {
        File xmlArgs = null;
        if (args.length > 0) {
            xmlArgs = args[0].startsWith("file:") ? new File(URI.create(args[0])) : new File(args[0]);
        } else {
            String homeDir = System.getProperty("user.home");
            xmlArgs = new File(homeDir, "test-run-props.xml");
        }
        if (!xmlArgs.exists()) {
            throw new IllegalArgumentException("Test run arguments not found at " + xmlArgs);
        }
        return xmlArgs;
    }
}

