/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.core.keyword.DfddKeywordMatcher;
import de.latlon.ets.core.keyword.DfddKeywordMatcherFromFile;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesKeywordTest
extends AbstractBaseGetCapabilitiesFixture {
    private static final DfddKeywordMatcher DFDD_KEYWORD_MATCHER = new DfddKeywordMatcherFromFile();

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.3., S.15, Requirement 12")
    public void wmsCapabilitiesContainsKeywordFromDFDDRegister() throws XPathFactoryConfigurationException, XPathExpressionException {
        List<String> keywords = this.parseKeywords(this.wmsCapabilities);
        boolean atLeastOneKeywordIsFromDfdd = DFDD_KEYWORD_MATCHER.containsAtLeastOneDfddKeyword(keywords);
        Assert.assertTrue((boolean)atLeastOneKeywordIsFromDfdd, (String)("Invalid keywords, expected is at least one keyword from DFDD, but is " + keywords));
    }

    private List<String> parseKeywords(Document wmsCapabilities) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathExpr = "//wms:WMS_Capabilities/wms:Service/wms:KeywordList/wms:Keyword";
        NodeList keywordNodes = (NodeList)this.createXPath().evaluate(xPathExpr, wmsCapabilities, XPathConstants.NODESET);
        ArrayList<String> keywords = new ArrayList<String>();
        for (int keywordNodeIndex = 0; keywordNodeIndex < keywordNodes.getLength(); ++keywordNodeIndex) {
            Node keywordNode = keywordNodes.item(keywordNodeIndex);
            String keyword = keywordNode.getTextContent();
            if (keyword == null) continue;
            keywords.add(keyword.trim());
        }
        return keywords;
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xpath;
    }
}

