/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import de.latlon.ets.wms13.core.domain.SuiteAttribute;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import javax.xml.namespace.NamespaceContext;
import javax.xml.soap.SOAPException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesLegendFormatTest
extends AbstractBaseGetCapabilitiesFixture {
    @DataProvider(name="layerNodes")
    public Object[][] parseLayerNodes(ITestContext testContext) throws XPathFactoryConfigurationException, XPathExpressionException {
        if (this.wmsCapabilities == null) {
            this.initBaseFixture(testContext);
        }
        NodeList layerNodes = ServiceMetadataUtils.parseRequestableLayerNodes(this.wmsCapabilities);
        Object[][] layers = new Object[layerNodes.getLength()][];
        for (int layerNodeIndex = 0; layerNodeIndex < layerNodes.getLength(); ++layerNodeIndex) {
            Node layerNode = layerNodes.item(layerNodeIndex);
            String name = (String)this.createXPath().evaluate("wms:Name", layerNode, XPathConstants.STRING);
            String title = (String)this.createXPath().evaluate("wms:Title", layerNode, XPathConstants.STRING);
            layers[layerNodeIndex] = new Object[]{layerNode, name, title};
        }
        return layers;
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.3., S.15, Requirement 16", dataProvider="layerNodes")
    public void wmsCapabilitiesLayersLegendExitsInCorrectFormat(ITestContext testContext, Node layerNode, String name, String title) throws SOAPException, XPathFactoryConfigurationException, XPathExpressionException {
        this.skipIfNoVectorData(testContext);
        Node formatNode = (Node)this.createXPath().evaluate("ancestor-or-self::wms:Layer/wms:Style/wms:LegendURL/wms:Format", layerNode, XPathConstants.NODE);
        Assert.assertNotNull((Object)formatNode, (String)("Style/LegendURL/Format element for layer (name: " + name + ", title: " + title + ") is missing."));
        String xPath = "text() = 'image/png' or 'image/gif' or 'image/jpeg'";
        ETSAssert.assertXPath((String)xPath, (Node)formatNode, (NamespaceBindings)NS_BINDINGS);
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xpath;
    }

    private void skipIfNoVectorData(ITestContext testContext) {
        boolean isVector = (Boolean)testContext.getSuite().getAttribute(SuiteAttribute.IS_VECTOR.getName());
        if (!isVector) {
            throw new SkipException("WMS does not contain vector data layers, tests are skipped!");
        }
    }
}

