/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesMinMaxScaleDenominatorsTest
extends AbstractBaseGetCapabilitiesFixture {
    @DataProvider(name="scaleDenominators")
    public Object[][] parseScaleDenominators(ITestContext testContext) throws XPathFactoryConfigurationException, XPathExpressionException {
        if (this.wmsCapabilities == null) {
            this.initBaseFixture(testContext);
        }
        NodeList layerNodes = this.parseLayer(this.wmsCapabilities);
        ArrayList<Object[]> scaleDenominators = new ArrayList<Object[]>();
        for (int layerNodeIndex = 0; layerNodeIndex < layerNodes.getLength(); ++layerNodeIndex) {
            Node layerNode = layerNodes.item(layerNodeIndex);
            Double minScaleDenominator = this.asDouble(layerNode, "wms:MinScaleDenominator/text()");
            Double maxScaleDenominator = this.asDouble(layerNode, "wms:MaxScaleDenominator/text()");
            if (Double.isNaN(minScaleDenominator) || Double.isNaN(maxScaleDenominator)) continue;
            scaleDenominators.add(new Object[]{minScaleDenominator, maxScaleDenominator});
        }
        return (Object[][])scaleDenominators.toArray((T[])new Object[scaleDenominators.size()][]);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.3., S.15, Requirement 19", dataProvider="scaleDenominators")
    public void wmsCapabilitiesLayerHasCorrectValuesForMinAndMaxDenominator(Double minScaleDenominator, Double maxScaleDenominator) {
        String message = String.format("minScaleDenomintor must be les or equal then maxScaleDenominator, but was %s (min) and %s (max)", minScaleDenominator, maxScaleDenominator);
        Assert.assertTrue((minScaleDenominator <= maxScaleDenominator ? 1 : 0) != 0, (String)message);
    }

    private NodeList parseLayer(Document entity) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathAbstract = "//wms:Layer";
        XPath xpath = this.createXPath();
        return (NodeList)xpath.evaluate(xPathAbstract, entity, XPathConstants.NODESET);
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xpath;
    }

    private double asDouble(Node layerNode, String expr) throws XPathExpressionException, XPathFactoryConfigurationException {
        String value = (String)this.createXPath().evaluate(expr, layerNode, XPathConstants.STRING);
        if (value != null && !value.isEmpty()) {
            return Double.parseDouble(value);
        }
        return Double.NaN;
    }
}

