/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.domain;

import de.latlon.ets.wms13.core.domain.BoundingBox;
import de.latlon.ets.wms13.core.domain.Dimension;
import java.util.List;

public class LayerInfo {
    private final String layerName;
    private final boolean isQueryable;
    private final List<BoundingBox> bboxes;
    private final List<Dimension> dimensions;
    private final BoundingBox geographicBbox;

    public LayerInfo(String layerName, boolean isQueryable, List<BoundingBox> bboxes, List<Dimension> dimensions, BoundingBox geographicBbox) {
        if (layerName == null || layerName.isEmpty()) {
            throw new IllegalArgumentException("layerName must not be null!");
        }
        if (bboxes == null) {
            throw new IllegalArgumentException("bboxes must not be null!");
        }
        if (dimensions == null) {
            throw new IllegalArgumentException("dimensions must not be null!");
        }
        if (geographicBbox == null) {
            throw new IllegalArgumentException("geographicBbox must not be null!");
        }
        this.isQueryable = isQueryable;
        this.layerName = layerName;
        this.bboxes = bboxes;
        this.dimensions = dimensions;
        this.geographicBbox = geographicBbox;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public boolean isQueryable() {
        return this.isQueryable;
    }

    public List<BoundingBox> getBboxes() {
        return this.bboxes;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public BoundingBox getGeographicBbox() {
        return this.geographicBbox;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bboxes == null ? 0 : this.bboxes.hashCode());
        result = 31 * result + (this.layerName == null ? 0 : this.layerName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayerInfo other = (LayerInfo)obj;
        if (this.bboxes == null ? other.bboxes != null : !this.bboxes.equals(other.bboxes)) {
            return false;
        }
        return !(this.layerName == null ? other.layerName != null : !this.layerName.equals(other.layerName));
    }

    public String toString() {
        return "LayerInfo [layerName=" + this.layerName + ", bboxes=" + this.bboxes + "]";
    }
}

