/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.domain.dimension.number;

import de.latlon.ets.wms13.core.domain.dimension.RequestableDimension;
import java.text.NumberFormat;
import java.util.Random;

public class NumberDimensionInterval
implements RequestableDimension {
    private static final Random RANDOM = new Random();
    private final Number min;
    private final Number max;
    private final Number resolution;

    public NumberDimensionInterval(Number min, Number max, Number resolution) {
        this.checkParameters(min, max, resolution);
        this.min = min;
        this.max = max;
        this.resolution = resolution;
    }

    @Override
    public String retrieveRequestableValue() {
        int steps = this.calculateStepsBetween();
        if (steps <= 0) {
            return this.asString(this.min.floatValue());
        }
        int stepsToGo = RANDOM.nextInt(steps);
        float newFloatValue = this.min.floatValue() + (float)stepsToGo * this.resolution.floatValue();
        return this.asString(newFloatValue);
    }

    public String toString() {
        return "NumberDimensionInterval [min=" + this.min + ", max=" + this.max + ", resolution=" + this.resolution + "]";
    }

    public Number getMin() {
        return this.min;
    }

    public Number getMax() {
        return this.max;
    }

    public Number getResolution() {
        return this.resolution;
    }

    private String asString(float newFloatValue) {
        return NumberFormat.getInstance().format(newFloatValue);
    }

    private int calculateStepsBetween() {
        float diff = this.max.floatValue() - this.min.floatValue();
        return Math.round(diff / this.resolution.floatValue());
    }

    private void checkParameters(Number min, Number max, Number resolution) {
        if (min == null) {
            throw new IllegalArgumentException("min must not be null!");
        }
        if (max == null) {
            throw new IllegalArgumentException("max must not be null!");
        }
        if (resolution == null) {
            throw new IllegalArgumentException("resolution must not be null!");
        }
        if (min.floatValue() > max.floatValue()) {
            throw new IllegalArgumentException("min must be less than or equal to max!");
        }
        if (resolution.floatValue() < 0.0f) {
            throw new IllegalArgumentException("resolution must be greater than or equal to 0!");
        }
    }
}

