/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.util;

import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.core.util.TestSuiteLogger;
import de.latlon.ets.wms13.core.domain.BoundingBox;
import de.latlon.ets.wms13.core.domain.Dimension;
import de.latlon.ets.wms13.core.domain.LayerInfo;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.domain.WmsNamespaces;
import de.latlon.ets.wms13.core.domain.dimension.DimensionUnitValue;
import de.latlon.ets.wms13.core.domain.dimension.RequestableDimension;
import de.latlon.ets.wms13.core.domain.dimension.RequestableDimensionList;
import de.latlon.ets.wms13.core.domain.dimension.date.DateTimeDimensionInterval;
import de.latlon.ets.wms13.core.domain.dimension.date.DateTimeRequestableDimension;
import de.latlon.ets.wms13.core.domain.dimension.number.NumberDimensionInterval;
import de.latlon.ets.wms13.core.domain.dimension.number.NumberRequestableDimension;
import java.net.URI;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.format.ISOPeriodFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ServiceMetadataUtils {
    private static final Logger LOGR = Logger.getLogger(ServiceMetadataUtils.class.getName());
    private static final NamespaceBindings NS_BINDINGS = WmsNamespaces.withStandardBindings();

    private ServiceMetadataUtils() {
    }

    public static URI getOperationEndpoint(Document wmsMetadata, String opName, ProtocolBinding binding) {
        if (null == binding || binding.equals((Object)ProtocolBinding.ANY)) {
            binding = ServiceMetadataUtils.getOperationBindings(wmsMetadata, opName).iterator().next();
        }
        if (binding == null) {
            return null;
        }
        String expr = "//wms:Request/wms:%s/wms:DCPType/wms:HTTP/wms:%s/wms:OnlineResource/@xlink:href";
        String xPathExpr = String.format(expr, opName, binding.getElementName());
        String href = null;
        try {
            XPath xPath = ServiceMetadataUtils.createXPath();
            href = xPath.evaluate(xPathExpr, wmsMetadata);
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log((Level)Level.INFO, (String)ex.getMessage());
        }
        return ServiceMetadataUtils.createEndpoint(href);
    }

    public static Set<ProtocolBinding> getOperationBindings(Document wmsMetadata, String opName) {
        HashSet<ProtocolBinding> protoBindings = new HashSet<ProtocolBinding>();
        if (ServiceMetadataUtils.isOperationBindingSupported(wmsMetadata, opName, ProtocolBinding.GET)) {
            protoBindings.add(ProtocolBinding.GET);
        }
        if (ServiceMetadataUtils.isOperationBindingSupported(wmsMetadata, opName, ProtocolBinding.POST)) {
            protoBindings.add(ProtocolBinding.POST);
        }
        return protoBindings;
    }

    public static List<String> parseSupportedFormats(Document wmsCapabilities, String opName) {
        ArrayList<String> supportedFormats = new ArrayList<String>();
        String expr = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:%s/wms:Format";
        String xPathExpr = String.format(expr, opName);
        try {
            XPath xPath = ServiceMetadataUtils.createXPath();
            NodeList formatNodes = (NodeList)xPath.evaluate(xPathExpr, wmsCapabilities, XPathConstants.NODESET);
            for (int formatNodeIndex = 0; formatNodeIndex < formatNodes.getLength(); ++formatNodeIndex) {
                Node formatNode = formatNodes.item(formatNodeIndex);
                String format = formatNode.getTextContent();
                if (format == null || format.isEmpty()) continue;
                supportedFormats.add(format);
            }
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log((Level)Level.INFO, (String)ex.getMessage());
        }
        return supportedFormats;
    }

    public static List<LayerInfo> parseLayerInfo(Document wmsCapabilities) {
        ArrayList<LayerInfo> layerInfos = new ArrayList<LayerInfo>();
        try {
            String layerExpr = "//wms:Layer[wms:Name/text() != '']";
            XPath xPath = ServiceMetadataUtils.createXPath();
            NodeList layerNodes = (NodeList)xPath.evaluate(layerExpr, wmsCapabilities, XPathConstants.NODESET);
            for (int layerNodeIndex = 0; layerNodeIndex < layerNodes.getLength(); ++layerNodeIndex) {
                Node layerNode = layerNodes.item(layerNodeIndex);
                LayerInfo layerInfo = ServiceMetadataUtils.parseLayerInfo(xPath, layerNode);
                layerInfos.add(layerInfo);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing layer infos from doc. ", e);
        }
        return layerInfos;
    }

    public static String parseUpdateSequence(Document wmsCapabilities) {
        try {
            String layerExpr = "//wms:WMS_Capabilities/@updateSequence ";
            XPath xPath = ServiceMetadataUtils.createXPath();
            String updateSequence = (String)xPath.evaluate(layerExpr, wmsCapabilities, XPathConstants.STRING);
            return updateSequence == null || updateSequence.isEmpty() ? null : updateSequence;
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
        }
    }

    public static BoundingBox parseGeographicBoundingBox(Node layerNode) {
        XPath xPath = ServiceMetadataUtils.createXPath();
        String bboxesExpr = "ancestor-or-self::wms:Layer/wms:EX_GeographicBoundingBox";
        try {
            NodeList bboxNodes = (NodeList)xPath.evaluate(bboxesExpr, layerNode, XPathConstants.NODESET);
            Node bboxNode = bboxNodes.item(bboxNodes.getLength() - 1);
            double minX = ServiceMetadataUtils.asDouble(bboxNode, "wms:westBoundLongitude", xPath);
            double minY = ServiceMetadataUtils.asDouble(bboxNode, "wms:southBoundLatitude", xPath);
            double maxX = ServiceMetadataUtils.asDouble(bboxNode, "wms:eastBoundLongitude", xPath);
            double maxY = ServiceMetadataUtils.asDouble(bboxNode, "wms:northBoundLatitude", xPath);
            return new BoundingBox("CRS:84", minX, minY, maxX, maxY);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc while parsing geographic BBOX of layer. ", xpe);
        }
    }

    public static NodeList parseAllLayerNodes(Document wmsCapabilities) throws XPathExpressionException {
        String xPathAbstract = "//wms:Layer";
        return ServiceMetadataUtils.createNodeList(wmsCapabilities, xPathAbstract);
    }

    public static NodeList parseRequestableLayerNodes(Document wmsCapabilities) throws XPathExpressionException {
        String xPathAbstract = "//wms:Layer[wms:Name]";
        return ServiceMetadataUtils.createNodeList(wmsCapabilities, xPathAbstract);
    }

    static RequestableDimension parseRequestableDimension(String units, String value) throws ParseException {
        if (value.contains(",")) {
            return ServiceMetadataUtils.parseListRequestableDimension(units, value);
        }
        return ServiceMetadataUtils.parseSingleRequestableDimension(units, value);
    }

    private static NodeList createNodeList(Document wmsCapabilities, String xPathAbstract) throws XPathExpressionException {
        XPath xpath = ServiceMetadataUtils.createXPath();
        return (NodeList)xpath.evaluate(xPathAbstract, wmsCapabilities, XPathConstants.NODESET);
    }

    private static RequestableDimension parseListRequestableDimension(String units, String value) throws ParseException {
        String[] singleValues;
        ArrayList<RequestableDimension> requestableDimensions = new ArrayList<RequestableDimension>();
        for (String singleValue : singleValues = value.split(",")) {
            requestableDimensions.add(ServiceMetadataUtils.parseSingleRequestableDimension(units, singleValue));
        }
        return new RequestableDimensionList(requestableDimensions);
    }

    private static RequestableDimension parseSingleRequestableDimension(String units, String singleValue) throws ParseException {
        if (singleValue.contains("/")) {
            return ServiceMetadataUtils.parseInterval(units, singleValue);
        }
        return ServiceMetadataUtils.parseSingleValue(units, singleValue);
    }

    private static RequestableDimension parseInterval(String units, String token) throws ParseException {
        LOGR.fine(String.format("Parsing temporal interval with units %s: %s", units, token));
        String[] minMaxRes = token.split("/");
        if ("ISO8601".equals(units)) {
            DateTime min = ServiceMetadataUtils.parseDateTime(minMaxRes[0]);
            DateTime max = ServiceMetadataUtils.parseDateTime(minMaxRes[1]);
            String period = minMaxRes.length > 2 ? minMaxRes[2] : "";
            Period resolution = ServiceMetadataUtils.parseResolution(period);
            return new DateTimeDimensionInterval(min, max, resolution);
        }
        Number min = ServiceMetadataUtils.parseNumber(minMaxRes[0]);
        Number max = ServiceMetadataUtils.parseNumber(minMaxRes[1]);
        Number resolution = ServiceMetadataUtils.parseNumber(minMaxRes[2]);
        return new NumberDimensionInterval(min, max, resolution);
    }

    private static Period parseResolution(String resolution) {
        if ("0".equals(resolution) || resolution.isEmpty()) {
            return null;
        }
        return ISOPeriodFormat.standard().parsePeriod(resolution);
    }

    private static RequestableDimension parseSingleValue(String units, String value) throws ParseException {
        if ("ISO8601".equals(units)) {
            DateTime dateTime = ServiceMetadataUtils.parseDateTime(value);
            return new DateTimeRequestableDimension(dateTime);
        }
        Number number = ServiceMetadataUtils.parseNumber(value);
        return new NumberRequestableDimension(number);
    }

    private static Number parseNumber(String token) throws ParseException {
        NumberFormat instance = NumberFormat.getInstance(Locale.ENGLISH);
        instance.setParseIntegerOnly(false);
        return instance.parse(token);
    }

    private static DateTime parseDateTime(String token) {
        Calendar dateTime = DatatypeConverter.parseDateTime((String)token);
        return new DateTime(dateTime.getTimeInMillis());
    }

    private static LayerInfo parseLayerInfo(XPath xPath, Node layerNode) throws XPathExpressionException, ParseException {
        String layerName = (String)xPath.evaluate("wms:Name", layerNode, XPathConstants.STRING);
        boolean isQueryable = ServiceMetadataUtils.parseQueryable(xPath, layerNode);
        List<BoundingBox> bboxes = ServiceMetadataUtils.parseBoundingBoxes(xPath, layerNode);
        List<Dimension> dimensions = ServiceMetadataUtils.parseDimensions(xPath, layerNode);
        BoundingBox geographicBbox = ServiceMetadataUtils.parseGeographicBoundingBox(layerNode);
        return new LayerInfo(layerName, isQueryable, bboxes, dimensions, geographicBbox);
    }

    private static boolean parseQueryable(XPath xPath, Node layerNode) throws XPathExpressionException {
        String queryableAttribute = (String)xPath.evaluate("@queryable", layerNode, XPathConstants.STRING);
        return queryableAttribute != null && ("1".equals(queryableAttribute) || Boolean.parseBoolean(queryableAttribute));
    }

    private static List<BoundingBox> parseBoundingBoxes(XPath xPath, Node layerNode) throws XPathExpressionException {
        HashMap<String, BoundingBox> bboxes = new HashMap<String, BoundingBox>();
        String bboxesExpr = "ancestor-or-self::wms:Layer/wms:BoundingBox";
        NodeList bboxNodes = (NodeList)xPath.evaluate(bboxesExpr, layerNode, XPathConstants.NODESET);
        for (int bboxNodeIndex = 0; bboxNodeIndex < bboxNodes.getLength(); ++bboxNodeIndex) {
            Node bboxNode = bboxNodes.item(bboxNodeIndex);
            BoundingBox bbox = ServiceMetadataUtils.parseBoundingBox(bboxNode);
            bboxes.put(bbox.getCrs(), bbox);
        }
        return new ArrayList<BoundingBox>(bboxes.values());
    }

    private static List<Dimension> parseDimensions(XPath xPath, Node layerNode) throws XPathExpressionException, ParseException {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        String dimensionExpr = "wms:Dimension";
        NodeList dimensionNodes = (NodeList)xPath.evaluate(dimensionExpr, layerNode, XPathConstants.NODESET);
        for (int dimensionNodeIndex = 0; dimensionNodeIndex < dimensionNodes.getLength(); ++dimensionNodeIndex) {
            Node dimensionNode = dimensionNodes.item(dimensionNodeIndex);
            Dimension dimension = ServiceMetadataUtils.parseDimension(xPath, dimensionNode);
            if (dimension == null) continue;
            dimensions.add(dimension);
        }
        return dimensions;
    }

    private static BoundingBox parseBoundingBox(Node bboxNode) throws XPathExpressionException {
        XPath xPath = ServiceMetadataUtils.createXPath();
        double minx = ServiceMetadataUtils.asDouble(bboxNode, "@minx", xPath);
        double miny = ServiceMetadataUtils.asDouble(bboxNode, "@miny", xPath);
        double maxx = ServiceMetadataUtils.asDouble(bboxNode, "@maxx", xPath);
        double maxy = ServiceMetadataUtils.asDouble(bboxNode, "@maxy", xPath);
        String crs = (String)xPath.evaluate("@CRS", bboxNode, XPathConstants.STRING);
        return new BoundingBox(crs, minx, miny, maxx, maxy);
    }

    private static Dimension parseDimension(XPath xPath, Node dimensionNode) throws XPathExpressionException, ParseException {
        String name = (String)xPath.evaluate("@name", dimensionNode, XPathConstants.STRING);
        if (name != null) {
            String units = (String)xPath.evaluate("@units", dimensionNode, XPathConstants.STRING);
            String value = (String)xPath.evaluate("text()", dimensionNode, XPathConstants.STRING);
            RequestableDimension requestableDimension = ServiceMetadataUtils.parseRequestableDimension(units, value);
            DimensionUnitValue unitValue = new DimensionUnitValue(units, requestableDimension);
            return new Dimension(name, unitValue);
        }
        return null;
    }

    private static double asDouble(Node node, String xPathExpr, XPath xPath) throws XPathExpressionException {
        String content = (String)xPath.evaluate(xPathExpr, node, XPathConstants.STRING);
        return Double.parseDouble(content);
    }

    private static boolean isOperationBindingSupported(Document wmsMetadata, String opName, ProtocolBinding binding) {
        String exprTemplate = "count(/wms:WMS_Capabilities/wms:Capability/wms:Request/wms:%s/wms:DCPType/wms:HTTP/wms:%s)";
        String xPathExpr = String.format(exprTemplate, opName, binding.getElementName());
        try {
            XPath xPath = ServiceMetadataUtils.createXPath();
            Double bindings = (Double)xPath.evaluate(xPathExpr, wmsMetadata, XPathConstants.NUMBER);
            if (bindings > 0.0) {
                return true;
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
        }
        return false;
    }

    private static URI createEndpoint(String href) {
        if (href == null || href.isEmpty()) {
            return null;
        }
        URI endpoint = URI.create(href);
        if (null != endpoint.getQuery()) {
            String uri = endpoint.toString();
            endpoint = URI.create(uri.substring(0, uri.indexOf(63)));
        }
        return endpoint;
    }

    private static XPath createXPath() {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xPath;
    }

    public static URI getSoapOperationEndpoint(Document wmsCapabilities, String operation) {
        if (ServiceMetadataUtils.isSoapSupported(wmsCapabilities, operation)) {
            String href = ServiceMetadataUtils.parseSoapEndpoint(wmsCapabilities);
            return ServiceMetadataUtils.createEndpoint(href);
        }
        return null;
    }

    private static String parseSoapEndpoint(Document wmsCapabilities) {
        String xPathExpr = "//wms:WMS_Capabilities/wms:Capability/soapwms:ExtendedCapabilities/soapwms:SOAP/wms:OnlineResource/@xlink:href";
        String href = null;
        try {
            XPath xPath = ServiceMetadataUtils.createXPath();
            href = xPath.evaluate("//wms:WMS_Capabilities/wms:Capability/soapwms:ExtendedCapabilities/soapwms:SOAP/wms:OnlineResource/@xlink:href", wmsCapabilities);
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log((Level)Level.INFO, (String)ex.getMessage());
        }
        return href;
    }

    private static boolean isSoapSupported(Document wmsCapabilities, String operation) {
        String exprTemplate = "//wms:WMS_Capabilities/wms:Capability/soapwms:ExtendedCapabilities/soapwms:SOAP/soapwms:SupportedOperations/soapwms:Operation[@name='%s']";
        String xPathExpr = String.format("//wms:WMS_Capabilities/wms:Capability/soapwms:ExtendedCapabilities/soapwms:SOAP/soapwms:SupportedOperations/soapwms:Operation[@name='%s']", operation);
        XPath xPath = ServiceMetadataUtils.createXPath();
        try {
            return (Boolean)xPath.evaluate(xPathExpr, wmsCapabilities, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
        }
    }
}

