/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wms13.nsg.testsuite.getcapabilities;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.net.URI;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class NsgGetCapabilitiesAbstractTest
extends AbstractBaseGetCapabilitiesFixture {
    private static final String NSG_EXPECTED_ABSTRACT = "This service implements the NSG OGC WMS 1.3 profile version 2.0.";

    @Test(description="NSG WMS Implementation Profile version 1.3.0, Requirement 2")
    public void wmsCapabilitiesAbstractContainsProfile(ITestContext testContext) throws XPathFactoryConfigurationException, XPathExpressionException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint((Document)this.wmsCapabilities, (String)"GetCapabilities", (ProtocolBinding)ProtocolBinding.GET);
        ClientResponse rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        String abstractValue = this.parseAbstract(rsp);
        Assert.assertTrue((boolean)abstractValue.contains(NSG_EXPECTED_ABSTRACT), (String)("Abstract is not valid, must contain the string 'This service implements the NSG OGC WMS 1.3 profile version 2.0. but is '" + abstractValue + "'"));
    }

    private String parseAbstract(ClientResponse rsp) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathAbstract = "//wms:WMS_Capabilities/wms:Service/wms:Abstract";
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return (String)xpath.evaluate(xPathAbstract, rsp.getEntity(Document.class), XPathConstants.STRING);
    }
}

