/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite;

import de.latlon.ets.wms13.core.assertion.WmsAssertion;
import de.latlon.ets.wms13.core.client.WmsClient;
import de.latlon.ets.wms13.core.domain.SuiteAttribute;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Prerequisites {
    @Test
    public void verifyServiceDescription(ITestContext testContext) {
        Document wmsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        WmsAssertion.assertSimpleWMSCapabilities(wmsMetadata);
    }

    @Test(dependsOnMethods={"verifyServiceDescription"})
    public void serviceIsAvailable(ITestContext testContext) {
        Document wmsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        WmsClient wmsClient = new WmsClient(wmsMetadata);
        Document capabilities = wmsClient.getCapabilities();
        Assert.assertNotNull(capabilities, "No GetCapabilities response from SUT.");
        Element docElement = capabilities.getDocumentElement();
        Assert.assertEquals(docElement.getLocalName(), "WMS_Capabilities", "Capabilities document element has unexpected [local name].");
        Assert.assertEquals(docElement.getNamespaceURI(), "http://www.opengis.net/wms", "Capabilities document element has unexpected [namespace name].");
    }
}

