/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.net.URI;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class GetCapabilitiesAbstractTest
extends AbstractBaseGetCapabilitiesFixture {
    private static final String EXPECTED_ABSTRACT = "This service implements the DGIWG WMS 1.3 profile version 1.0.";

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.3., S.15, Requirement 11")
    public void wmsCapabilitiesAbstractContainsProfile() throws XPathFactoryConfigurationException, XPathExpressionException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        ClientResponse rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        String abstractValue = this.parseAbstract(rsp);
        Assert.assertTrue(abstractValue.contains(EXPECTED_ABSTRACT), "Abstract is not valid, must contain the string 'This service implements the DGIWG WMS 1.3 profile version 1.0. but is '" + abstractValue + "'");
    }

    private String parseAbstract(ClientResponse rsp) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathAbstract = "//wms:WMS_Capabilities/wms:Service/wms:Abstract";
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(NS_BINDINGS);
        return (String)xpath.evaluate(xPathAbstract, rsp.getEntity(Document.class), XPathConstants.STRING);
    }
}

