/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesFeatureListUrlTest
extends AbstractBaseGetCapabilitiesFixture {
    @DataProvider(name="featureListUrls")
    public Object[][] parseFeatureListUrlNodes(ITestContext testContext) throws XPathFactoryConfigurationException, XPathExpressionException {
        if (this.wmsCapabilities == null) {
            this.initBaseFixture(testContext);
        }
        NodeList featureListUrlNodes = this.parseFeatureListUrlNodes(this.wmsCapabilities);
        Object[][] featureListUrls = new Object[featureListUrlNodes.getLength()][];
        for (int featureListUrlNodeIndex = 0; featureListUrlNodeIndex < featureListUrlNodes.getLength(); ++featureListUrlNodeIndex) {
            Node featureListUrlNode = featureListUrlNodes.item(featureListUrlNodeIndex);
            String featureListUrl = (String)this.createXPath().evaluate("//@xlink:href", featureListUrlNode, XPathConstants.STRING);
            featureListUrls[featureListUrlNodeIndex] = new Object[]{featureListUrl};
        }
        return featureListUrls;
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.3., S.17, Requirement 20", dataProvider="featureListUrls")
    public void wmsCapabilitiesFeatureListUrlIsResolvable(String featureListUrl) throws XPathExpressionException, XPathFactoryConfigurationException {
        ETSAssert.assertUrl(featureListUrl);
        ETSAssert.assertUriIsResolvable(featureListUrl);
    }

    private NodeList parseFeatureListUrlNodes(Document entity) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathFeatureListUrls = "//wms:Layer/wms:FeatureListURL/wms:OnlineResource";
        XPath xpath = this.createXPath();
        return (NodeList)xpath.evaluate(xPathFeatureListUrls, entity, XPathConstants.NODESET);
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(NS_BINDINGS);
        return xpath;
    }
}

