/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.uom;

import de.latlon.ets.core.util.TestSuiteLogger;
import de.latlon.ets.wms13.core.uom.UomMatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class UomMatcherFromFile
implements UomMatcher {
    private static final String UOM_FILE = "uom.txt";
    private List<String> expectedUoms = this.parseUomsFromStream();

    @Override
    public boolean isExpectedUoM(String uom) {
        return this.expectedUoms.contains(uom);
    }

    List<String> parseUomsFromStream() {
        ArrayList<String> uoms = new ArrayList<String>();
        try (InputStream resource = this.getClass().getResourceAsStream(UOM_FILE);
             BufferedReader br = new BufferedReader(new InputStreamReader(resource, "UTF-8"));){
            String line;
            while ((line = br.readLine()) != null) {
                String uom = line.trim();
                if (uom.isEmpty()) continue;
                uoms.add(uom);
            }
        }
        catch (IOException e) {
            TestSuiteLogger.log(Level.WARNING, "UoM file uom.txt could not be parsed.", e);
        }
        TestSuiteLogger.log(Level.CONFIG, String.format("Recogized units of measure: %s", ((Object)uoms).toString()));
        return uoms;
    }
}

