/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wms13.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class NsgGetCapabilitiesContentTest
extends AbstractBaseGetCapabilitiesFixture {
    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesNameExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:Name/text() != ''";
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesTitleExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:Title/text() != ''";
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesOnlineResourceExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:OnlineResource/@xlink:href != ''";
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesAbstractExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:Abstract";
        this.skipIfNoOptionalMetadata(xPathXml);
        xPathXml = xPathXml + "/text() != ''";
        this.skipIfNoOptionalMetadata(xPathXml);
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesKeywordListExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:KeywordList";
        this.skipIfNoOptionalMetadata(xPathXml);
        xPathXml = xPathXml + "/text() != ''";
        this.skipIfNoOptionalMetadata(xPathXml);
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesContactInformationExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:ContactInformation";
        this.skipIfNoOptionalMetadata(xPathXml);
        xPathXml = xPathXml + "/text() != ''";
        this.skipIfNoOptionalMetadata(xPathXml);
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesFeesExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:Fees";
        this.skipIfNoOptionalMetadata(xPathXml);
        xPathXml = xPathXml + "/text() != ''";
        this.skipIfNoOptionalMetadata(xPathXml);
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesAccessConstraintsExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:AccessConstraints";
        this.skipIfNoOptionalMetadata(xPathXml);
        xPathXml = xPathXml + "/text() != ''";
        this.skipIfNoOptionalMetadata(xPathXml);
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 9")
    public void wmsCapabilitiesLayerLimitExistsAndPopulated() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:LayerLimit";
        this.skipIfNoOptionalMetadata(xPathXml);
        xPathXml = xPathXml + "/text() != ''";
        this.skipIfNoOptionalMetadata(xPathXml);
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    private void skipIfNoOptionalMetadata(String xPath) {
        boolean metadataEvaluates = ETSAssert.checkXPath(xPath, this.wmsCapabilities, NS_BINDINGS);
        if (!metadataEvaluates) {
            if (xPath.endsWith("''")) {
                throw new SkipException("The WMS contains the optional capabilities metadata but is blank, tests are skipped!");
            }
            throw new SkipException("The WMS does not contain optional capabilities metadata, tests are skipped!");
        }
    }
}

