/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import de.latlon.ets.core.util.XMLUtils;
import de.latlon.ets.wms13.core.client.WmsKvpRequest;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.SOAPMessageConsumer;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.xml.transform.Source;
import org.w3c.dom.Document;

public class WmsClient {
    private static final Logger LOGR = Logger.getLogger(WmsClient.class.getPackage().getName());
    private Client client;
    private Document wmsCapabilities;

    public WmsClient(Document wmsCapabilities) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(SOAPMessageConsumer.class);
        this.client = Client.create((ClientConfig)config);
        this.client.addFilter((ClientFilter)new LoggingFilter());
        this.wmsCapabilities = wmsCapabilities;
    }

    public Document getCapabilities() {
        if (null == this.wmsCapabilities) {
            throw new IllegalStateException("Service description is unavailable.");
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        if (null == endpoint) {
            throw new RuntimeException("GetCapabilities (GET) endpoint not found in capabilities document.");
        }
        WebResource resource = this.client.resource(endpoint);
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"request", (Object)"GetCapabilities");
        queryParams.add((Object)"service", (Object)"WMS");
        queryParams.add((Object)"version", (Object)"1.3.0");
        return (Document)resource.queryParams((MultivaluedMap)queryParams).get(Document.class);
    }

    public ClientResponse submitRequest(WmsKvpRequest request, URI endpoint) {
        WebResource resource = this.client.resource(endpoint);
        return this.submitGetRequest(resource, request);
    }

    public ClientResponse submitRequest(Source payload, URI endpoint) {
        if (payload == null || endpoint == null) {
            throw new IllegalArgumentException("Neither payload nor endpoint must be null");
        }
        WebResource resource = this.client.resource(endpoint);
        resource.uri(UriBuilder.fromUri((URI)endpoint).build(new Object[0]));
        return this.submitPostRequest(resource, payload);
    }

    private ClientResponse submitPostRequest(WebResource resource, Source payload) {
        LOGR.log(Level.FINE, String.format("Submitting POST request to URI %s", resource.getURI()));
        LOGR.log(Level.FINE, String.format("Request Payload: %s", XMLUtils.transformToString((Source)payload)));
        ClientResponse response = null;
        try {
            response = (ClientResponse)((WebResource.Builder)resource.accept(new String[]{"application/soap+xml"}).type("application/soap+xml")).post(ClientResponse.class, (Object)payload);
            if (LOGR.isLoggable(Level.FINE)) {
                LOGR.log(Level.FINE, String.format("SOAP Response: %s", response.toString()));
            }
        }
        catch (ClientHandlerException | UniformInterfaceException ex) {
            LOGR.log(Level.SEVERE, "Failed to process SOAP request/response: " + resource.getURI(), ex);
        }
        return response;
    }

    private ClientResponse submitGetRequest(WebResource resource, WmsKvpRequest requestParameter) {
        LOGR.log(Level.FINE, String.format("Submitting GET request to URI %s", resource.getURI()));
        String queryString = requestParameter.asQueryString();
        URI requestURI = UriBuilder.fromUri((URI)resource.getURI()).replaceQuery(queryString).build(new Object[0]);
        LOGR.log(Level.FINE, String.format("Request URI: %s", requestURI));
        resource = resource.uri(requestURI);
        return (ClientResponse)resource.get(ClientResponse.class);
    }
}

