/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.wms13.core.assertion.WmsAssertion;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.net.URI;
import javax.xml.soap.SOAPException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class GetCapabilitiesOutputFormatTest
extends AbstractBaseGetCapabilitiesFixture {
    @BeforeMethod
    public void clearRequest() {
        this.reqEntity.removeKvp("FORMAT");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3")
    public void wmsCapabilitiesOutputFormatXmlSupported() throws SOAPException {
        String xPathXml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetCapabilities/wms:Format/text() = 'text/xml'";
        ETSAssert.assertXPath(xPathXml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3")
    public void wmsCapabilitiesOutputFormatHtmlSupported() throws SOAPException {
        String xPathHtml = "//wms:WMS_Capabilities/wms:Capability/wms:Request/wms:GetCapabilities/wms:Format/text() = 'text/html'";
        ETSAssert.assertXPath(xPathHtml, this.wmsCapabilities, NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3", dependsOnMethods={"wmsCapabilitiesOutputFormatXmlSupported"})
    public void wmsGetCapabilitiesOutputFormatXmlSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        this.reqEntity.addKvp("FORMAT", "text/xml");
        ClientResponse rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        WmsAssertion.assertSimpleWMSCapabilities(rsp.getEntity(Document.class));
        ETSAssert.assertContentType(rsp.getHeaders(), "text/xml");
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.5.3.1., S.9, Requirement 3", dependsOnMethods={"wmsCapabilitiesOutputFormatHtmlSupported"})
    public void wmsGetCapabilitiesOutputFormatHtmlSupported() throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        this.reqEntity.addKvp("FORMAT", "text/html");
        ClientResponse rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        ETSAssert.assertContentType(rsp.getHeaders(), "text/html");
    }
}

