/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesStyleTest
extends AbstractBaseGetCapabilitiesFixture {
    @DataProvider(name="styleNodes")
    public Object[][] parseStyleNodes(ITestContext testContext) throws XPathFactoryConfigurationException, XPathExpressionException {
        if (this.wmsCapabilities == null) {
            this.initBaseFixture(testContext);
        }
        NodeList styleNodes = this.parseStyleNodes(this.wmsCapabilities);
        Object[][] styles = new Object[styleNodes.getLength()][];
        for (int styleNodeIndex = 0; styleNodeIndex < styleNodes.getLength(); ++styleNodeIndex) {
            Node styleNode = styleNodes.item(styleNodeIndex);
            String layerName = (String)this.createXPath().evaluate("../wms:Name", styleNode, XPathConstants.STRING);
            String layerTitle = (String)this.createXPath().evaluate("../wms:Title", styleNode, XPathConstants.STRING);
            styles[styleNodeIndex] = new Object[]{styleNode, layerName, layerTitle};
        }
        return styles;
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.3., S.15, Requirement 13", dataProvider="styleNodes")
    public void wmsCapabilitiesStylesHasNameAndTitle(Node styleNode, String layerName, String layerTitle) throws XPathExpressionException, XPathFactoryConfigurationException {
        String styleName = (String)this.createXPath().evaluate("wms:Name/text()", styleNode, XPathConstants.STRING);
        Assert.assertNotNull(styleName, "Name element of the style is missing");
        Assert.assertNotEquals((Object)styleName, (Object)"Name element of the style is empty");
        String styleTitle = (String)this.createXPath().evaluate("wms:Title/text()", styleNode, XPathConstants.STRING);
        Assert.assertNotNull(styleTitle, "Title element of the style is missing");
        Assert.assertNotEquals((Object)styleTitle, (Object)"", "Title element of the style is empty");
    }

    private NodeList parseStyleNodes(Document entity) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathAbstract = "//wms:Layer/wms:Style";
        XPath xpath = this.createXPath();
        return (NodeList)xpath.evaluate(xPathAbstract, entity, XPathConstants.NODESET);
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(NS_BINDINGS);
        return xpath;
    }
}

