/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wms13.core.dgiwg.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import de.latlon.ets.wms13.core.domain.ProtocolBinding;
import de.latlon.ets.wms13.core.util.ServiceMetadataUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetCapabilitiesAccessConstraintTest
extends AbstractBaseGetCapabilitiesFixture {
    private static final List<String> EXPECTED_ACCESS_CONSTRAINTS = Arrays.asList("unclassified", "restricted", "confidential", "secret", "topSecret");

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 10")
    public void wmsCapabilitiesAccessConstraintsExists() {
        String xPathXml = "//wms:WMS_Capabilities/wms:Service/wms:AccessConstraints != ''";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wmsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Map Service 1.3 Profile, 6.6.2.2., S.13, Requirement 10", dependsOnMethods={"wmsCapabilitiesAccessConstraintsExists"})
    public void wmsCapabilitiesAccessConstraintsContainsValueFromDMF() throws XPathFactoryConfigurationException, XPathExpressionException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wmsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        ClientResponse rsp = this.wmsClient.submitRequest(this.reqEntity, endpoint);
        String accessConstraints = this.parseAccessConstraints(rsp);
        Assert.assertTrue((boolean)EXPECTED_ACCESS_CONSTRAINTS.contains(accessConstraints), (String)("AccessConstraints are not valid, must be one of " + EXPECTED_ACCESS_CONSTRAINTS + " but was " + accessConstraints));
    }

    private String parseAccessConstraints(ClientResponse rsp) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathAccessConstraints = "//wms:WMS_Capabilities/wms:Service/wms:AccessConstraints";
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return (String)xpath.evaluate(xPathAccessConstraints, rsp.getEntity(Document.class), XPathConstants.STRING);
    }
}

