/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import com.occamlab.te.parsers.ValidationError;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlErrorHandler
implements ErrorHandler {
    private StringBuffer buf = new StringBuffer();
    private List<ValidationError> errors = new ArrayList<ValidationError>();
    private static Logger jlogger = Logger.getLogger("com.occamlab.te.parsers.XmlErrorHandler");

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    @Override
    public void warning(SAXParseException spex) {
        this.addError((short)1, spex);
    }

    @Override
    public void error(SAXParseException spex) {
        this.addError((short)2, spex);
    }

    void printError(String type, SAXParseException e) {
        PrintWriter logger = new PrintWriter(System.out);
        logger.print(type);
        if (e.getLineNumber() >= 0) {
            logger.print(" at line " + e.getLineNumber());
            if (e.getColumnNumber() >= 0) {
                logger.print(", column " + e.getColumnNumber());
            }
            if (e.getSystemId() != null) {
                logger.print(" of " + e.getSystemId());
            }
        } else if (e.getSystemId() != null) {
            logger.print(" in " + e.getSystemId());
        }
        logger.println(":");
        logger.println("  " + e.getMessage());
        logger.flush();
    }

    @Override
    public void fatalError(SAXParseException spex) throws SAXException {
        this.addError((short)3, spex);
        throw new SAXException("Fatal error while parsing input.");
    }

    private void addError(short severity, SAXParseException spex) {
        if (spex.getLineNumber() > 0) {
            this.buf.append("Line " + spex.getLineNumber() + " - ");
        }
        this.buf.append(spex.getMessage() + "\n");
        ValidationError error = new ValidationError(severity, this.buf.toString());
        this.errors.add(error);
        this.buf.setLength(0);
    }

    public String toString() {
        this.buf.setLength(0);
        ErrorIterator errIterator = this.iterator();
        while (errIterator.hasNext()) {
            ValidationError err = errIterator.next();
            this.buf.append(err.getMessage());
        }
        return this.buf.toString();
    }

    public List<String> toList() {
        ArrayList<String> errorStrings = new ArrayList<String>();
        ErrorIterator errIterator = this.iterator();
        while (errIterator.hasNext()) {
            ValidationError err = errIterator.next();
            errorStrings.add(err.getMessage());
        }
        return errorStrings;
    }

    public Element toRootElement() {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "validate", e);
            e.printStackTrace();
        }
        Element root = doc.createElement("errors");
        doc.appendChild(root);
        ErrorIterator errIterator = this.iterator();
        while (errIterator.hasNext()) {
            ValidationError err = errIterator.next();
            Element elem = doc.createElement("error");
            elem.setTextContent(err.getMessage());
            root.appendChild(elem);
        }
        return root;
    }

    public NodeList toNodeList() {
        return this.toRootElement().getElementsByTagName("error");
    }

    public ErrorIterator iterator() {
        return new ErrorIterator();
    }

    public void reset() {
        this.buf.setLength(0);
        this.errors.clear();
    }

    public class ErrorIterator {
        Iterator<ValidationError> underlying;

        public ErrorIterator() {
            this.underlying = XmlErrorHandler.this.errors.iterator();
        }

        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        public ValidationError next() {
            return this.underlying.next();
        }
    }
}

