/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.executors.testng;

import com.occamlab.te.spi.executors.testng.TestRunSummary;
import com.occamlab.te.spi.vocabulary.CITE;
import com.occamlab.te.spi.vocabulary.CONTENT;
import com.occamlab.te.spi.vocabulary.EARL;
import com.occamlab.te.spi.vocabulary.HTTP;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.vocabulary.DCTerms;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class EarlReporter
implements IReporter {
    private static final Logger LOGR = Logger.getLogger(EarlReporter.class.getPackage().getName());
    private String langCode = "en";
    private static final String TEST_RUN_ID = "uuid";
    private Resource testRun;
    private int resultCount = 0;
    private Resource assertor;
    private Resource testSubject;
    private static final String REQ_ATTR = "request";
    private static final String RSP_ATTR = "response";
    private Model earlModel = ModelFactory.createDefaultModel();

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        for (ISuite suite : suites) {
            Model model = this.initializeModel(suite);
            this.addTestRequirements(model, suite.getXmlSuite().getTests());
            this.addTestInputs(model, suite.getXmlSuite().getAllParameters());
            TestRunSummary summary = new TestRunSummary(suite);
            this.testRun.addLiteral(CITE.testsPassed, new Integer(summary.getTotalPassed()));
            this.testRun.addLiteral(CITE.testsFailed, new Integer(summary.getTotalFailed()));
            this.testRun.addLiteral(CITE.testsSkipped, new Integer(summary.getTotalSkipped()));
            Literal duration = model.createTypedLiteral(summary.getTotalDuration(), (RDFDatatype)XSDDatatype.XSDduration);
            this.testRun.addLiteral(DCTerms.extent, duration);
            this.processSuiteResults(model, suite.getResults());
            this.earlModel.add(model);
        }
        File outputDir = new File(outputDirectory);
        if (!outputDir.isDirectory()) {
            outputDir = new File(System.getProperty("java.io.tmpdir"));
        }
        try {
            this.writeModel(this.earlModel, outputDir, true);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to serialize EARL results to " + outputDir.getAbsolutePath(), iox);
        }
    }

    void processSuiteResults(Model model, Map<String, ISuiteResult> results) {
        for (Map.Entry<String, ISuiteResult> entry : results.entrySet()) {
            String testReqName = entry.getKey().replaceAll("\\s", "-");
            Resource testReq = model.createResource(testReqName);
            ITestContext testContext = entry.getValue().getTestContext();
            int nPassed = testContext.getPassedTests().size();
            int nSkipped = testContext.getSkippedTests().size();
            int nFailed = testContext.getFailedTests().size();
            testReq.addLiteral(CITE.testsPassed, new Integer(nPassed));
            testReq.addLiteral(CITE.testsFailed, new Integer(nFailed));
            testReq.addLiteral(CITE.testsSkipped, new Integer(nSkipped));
            if (nPassed + nFailed == 0) {
                testReq.addProperty(DCTerms.description, "A precondition was not met. All tests in this set were skipped.");
            }
            this.processTestResults(model, testContext.getFailedTests());
            this.processTestResults(model, testContext.getSkippedTests());
            this.processTestResults(model, testContext.getPassedTests());
        }
    }

    Model initializeModel(ISuite suite) {
        Model model = ModelFactory.createDefaultModel();
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("earl", "http://www.w3.org/ns/earl#");
        nsBindings.put("dct", "http://purl.org/dc/terms/");
        nsBindings.put("cite", "http://cite.opengeospatial.org/");
        nsBindings.put("http", "http://www.w3.org/2011/http#");
        nsBindings.put("cnt", "http://www.w3.org/2011/content#");
        model.setNsPrefixes(nsBindings);
        this.testRun = model.createResource(CITE.TestRun);
        this.testRun.addProperty(DCTerms.title, suite.getName());
        String nowUTC = ZonedDateTime.now(ZoneId.of("Z")).format(DateTimeFormatter.ISO_INSTANT);
        this.testRun.addProperty(DCTerms.created, nowUTC);
        this.assertor = model.createResource("https://github.com/opengeospatial/teamengine", EARL.Assertor);
        this.assertor.addProperty(DCTerms.title, "OGC TEAM Engine", this.langCode);
        this.assertor.addProperty(DCTerms.description, "Official test harness of the OGC conformance testing program (CITE).", this.langCode);
        Map<String, String> params = suite.getXmlSuite().getAllParameters();
        String iut = params.get("iut");
        if (null == iut) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                try {
                    URI uri = URI.create(param.getValue());
                    iut = uri.toString();
                }
                catch (IllegalArgumentException e) {}
            }
        }
        if (null == iut) {
            throw new NullPointerException("Unable to find URI reference for IUT in test run parameters.");
        }
        this.testSubject = model.createResource(iut, EARL.TestSubject);
        return model;
    }

    void addTestRequirements(Model earl, List<XmlTest> testList) {
        Seq reqs = earl.createSeq();
        for (XmlTest xmlTest : testList) {
            String testName = xmlTest.getName();
            Resource testReq = earl.createResource(testName.replaceAll("\\s", "-"), EARL.TestRequirement);
            testReq.addProperty(DCTerms.title, testName);
            reqs.add(testReq);
        }
        this.testRun.addProperty(CITE.requirements, reqs);
    }

    void addTestInputs(Model earl, Map<String, String> params) {
        Bag inputs = earl.createBag();
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (param.getKey().equals(TEST_RUN_ID)) {
                this.testRun.addProperty(DCTerms.identifier, param.getValue());
                continue;
            }
            if (param.getValue().isEmpty()) continue;
            Resource testInput = earl.createResource();
            testInput.addProperty(DCTerms.title, param.getKey());
            testInput.addProperty(DCTerms.description, param.getValue());
            inputs.add(testInput);
        }
        this.testRun.addProperty(CITE.inputs, inputs);
    }

    void writeModel(Model model, File outputDirectory, boolean abbreviated) throws IOException {
        if (!outputDirectory.isDirectory()) {
            throw new IllegalArgumentException("Directory does not exist at " + outputDirectory.getAbsolutePath());
        }
        File outputFile = new File(outputDirectory, "earl-results.rdf");
        if (!outputFile.createNewFile()) {
            outputFile.delete();
            outputFile.createNewFile();
        }
        LOGR.log(Level.CONFIG, "Writing EARL results to" + outputFile.getAbsolutePath());
        String syntax = abbreviated ? "RDF/XML-ABBREV" : "RDF/XML";
        String baseUri = "http://example.org/earl/" + outputDirectory.getName() + '/';
        FileOutputStream outStream = new FileOutputStream(outputFile);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8);){
            model.write(writer, syntax, baseUri);
        }
    }

    String getDetailMessage(ITestResult result) {
        if (null == result.getThrowable()) {
            return "No details available.";
        }
        String msg = result.getThrowable().getMessage();
        msg = null == msg && null != result.getThrowable().getCause() ? result.getThrowable().getCause().getMessage() : result.getThrowable().toString();
        return msg;
    }

    void processTestResults(Model earl, IResultMap results) {
        for (ITestResult tngResult : results.getAllResults()) {
            long endTime = tngResult.getEndMillis();
            GregorianCalendar calTime = new GregorianCalendar(TimeZone.getDefault());
            calTime.setTimeInMillis(endTime);
            Resource assertion = earl.createResource("assert-" + ++this.resultCount, EARL.Assertion);
            assertion.addProperty(EARL.mode, EARL.AutomaticMode);
            assertion.addProperty(EARL.assertedBy, this.assertor);
            assertion.addProperty(EARL.subject, this.testSubject);
            Resource earlResult = earl.createResource("result-" + this.resultCount, EARL.TestResult);
            earlResult.addProperty(DCTerms.date, earl.createTypedLiteral(calTime));
            switch (tngResult.getStatus()) {
                case 2: {
                    earlResult.addProperty(DCTerms.description, this.getDetailMessage(tngResult));
                    if (AssertionError.class.isInstance(tngResult.getThrowable())) {
                        earlResult.addProperty(EARL.outcome, EARL.Fail);
                    } else {
                        earlResult.addProperty(EARL.outcome, EARL.CannotTell);
                    }
                    this.processResultAttributes(earlResult, tngResult);
                    break;
                }
                case 3: {
                    earlResult.addProperty(DCTerms.description, this.getDetailMessage(tngResult));
                    earlResult.addProperty(EARL.outcome, EARL.NotTested);
                    break;
                }
                default: {
                    earlResult.addProperty(EARL.outcome, EARL.Pass);
                }
            }
            assertion.addProperty(EARL.result, earlResult);
            String testMethodName = tngResult.getMethod().getMethodName();
            String testClassName = tngResult.getTestClass().getName().replaceAll("\\.", "/");
            StringBuilder testCaseId = new StringBuilder(testClassName);
            testCaseId.append('#').append(testMethodName);
            Resource testCase = earl.createResource(testCaseId.toString(), EARL.TestCase);
            testCase.addProperty(DCTerms.title, testMethodName);
            String testDescr = tngResult.getMethod().getDescription();
            if (null != testDescr && !testDescr.isEmpty()) {
                testCase.addProperty(DCTerms.description, testDescr);
            }
            assertion.addProperty(EARL.test, testCase);
            String testReqName = tngResult.getTestContext().getName().replaceAll("\\s", "-");
            earl.createResource(testReqName).addProperty(DCTerms.hasPart, testCase);
        }
    }

    void processResultAttributes(Resource earlResult, ITestResult tngResult) {
        if (!tngResult.getAttributeNames().contains(REQ_ATTR)) {
            return;
        }
        String reqVal = tngResult.getAttribute(REQ_ATTR).toString();
        String httpMethod = reqVal.startsWith("<") ? "POST" : "GET";
        Resource httpReq = this.earlModel.createResource(HTTP.Request);
        httpReq.addProperty(HTTP.methodName, httpMethod);
        if (httpMethod.equals("GET")) {
            httpReq.addProperty(HTTP.requestURI, reqVal);
        } else {
            Resource reqContent = this.earlModel.createResource(CONTENT.ContentAsXML);
            reqContent.addProperty(CONTENT.rest, reqVal);
            httpReq.addProperty(HTTP.body, reqContent);
        }
        Object rsp = tngResult.getAttribute(RSP_ATTR);
        if (null != rsp) {
            Resource httpRsp = this.earlModel.createResource(HTTP.Response);
            Resource rspContent = this.earlModel.createResource(CONTENT.ContentAsXML);
            rspContent.addProperty(CONTENT.rest, rsp.toString());
            httpRsp.addProperty(HTTP.body, rspContent);
            httpReq.addProperty(HTTP.resp, httpRsp);
        }
        earlResult.addProperty(CITE.message, httpReq);
    }
}

