/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtils {
    public static Node addDomAttr(Document doc, String tagName, String tagNamespaceURI, String attrName, String attrValue) {
        Document newDoc = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            newDoc = db.newDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Transformer identity = null;
        try {
            TransformerFactory TF = TransformerFactory.newInstance();
            TF.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            identity = TF.newTransformer();
            identity.transform(new DOMSource(doc), new DOMResult(newDoc));
        }
        catch (Exception ex) {
            System.out.println("ERROR: " + ex.getMessage());
        }
        NodeList namedTags = newDoc.getElementsByTagNameNS(tagNamespaceURI, tagName);
        for (int i = 0; i < namedTags.getLength(); ++i) {
            Element element = (Element)namedTags.item(i);
            element.setAttribute(attrName, attrValue);
        }
        return newDoc;
    }

    public static boolean checkCommentNodes(Node node, String str) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Comment comment;
            boolean okDownThere;
            Node child = children.item(i);
            NodeList childChildren = child.getChildNodes();
            if (childChildren.getLength() > 0 && (okDownThere = DomUtils.checkCommentNodes(child, str))) {
                return true;
            }
            if (child.getNodeType() != 8 || !(comment = (Comment)child).getNodeValue().contains(str)) continue;
            return true;
        }
        return false;
    }

    public static String serializeNode(Node node) {
        return DomUtils.serializeSource(new DOMSource(node));
    }

    public static String serializeSource(Source source) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            StreamResult dest = new StreamResult(baos);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, dest);
        }
        catch (Exception e) {
            System.out.println("Error serializing node.  " + e.getMessage());
        }
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return baos.toString();
        }
    }

    public static String serializeNoNS(Node node) {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(node.getLocalName());
        for (Map.Entry<QName, String> entry : DomUtils.getAttributes(node).entrySet()) {
            QName name = entry.getKey();
            if (name.getNamespaceURI() == null) continue;
            buf.append(" ");
            buf.append(name.getLocalPart());
            buf.append("=\"");
            buf.append(entry.getValue());
            buf.append("\"");
        }
        boolean tagOpen = true;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            short type = node.getNodeType();
            if (type == 3) {
                if (tagOpen) {
                    buf.append(">\n");
                    tagOpen = false;
                }
                buf.append(node.getTextContent());
                continue;
            }
            if (type != 1) continue;
            if (tagOpen) {
                buf.append(">\n");
                tagOpen = false;
            }
            buf.append(DomUtils.serializeNoNS(n));
            buf.append("\n");
        }
        if (tagOpen) {
            buf.append("/>\n");
        } else {
            buf.append("</");
            buf.append(node.getLocalName());
            buf.append(">\n");
        }
        return buf.toString();
    }

    public static void displayNode(Node node) {
        try {
            TransformerFactory TF = TransformerFactory.newInstance();
            TF.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer identity = TF.newTransformer();
            identity.transform(new DOMSource(node), new StreamResult(System.out));
        }
        catch (Exception ex) {
            System.out.println("ERROR: " + ex.getMessage());
        }
    }

    public static Element getElement(Node node) {
        if (node.getNodeType() == 9) {
            return ((Document)node).getDocumentElement();
        }
        if (node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    public static Map<QName, String> getAttributes(Node node) {
        HashMap<QName, String> atts = new HashMap<QName, String>();
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                Attr att = (Attr)nnm.item(i);
                String uri = att.getBaseURI();
                String localname = att.getLocalName();
                String prefix = att.getPrefix();
                QName name = uri == null ? new QName(localname) : (prefix == null ? new QName(uri, localname) : new QName(uri, localname, prefix));
                if (prefix != null && (prefix.equals("xmlns") || prefix.equals("xml"))) continue;
                atts.put(name, att.getValue());
            }
        }
        return atts;
    }

    public static Document createDocument(Node node) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        Document doc = dbf.newDocumentBuilder().newDocument();
        if (node != null) {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer t = tf.newTransformer();
            t.transform(new DOMSource(node), new DOMResult(doc));
        }
        return doc;
    }

    public static Element getChildElement(Node node) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static List<Element> getChildElements(Node node) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            list.add((Element)nl.item(i));
        }
        return list;
    }

    public static Element getElementByTagName(Node node, String tagname) {
        NodeList nl;
        if (node.getNodeType() == 9) {
            nl = ((Document)node).getElementsByTagName(tagname);
        } else if (node.getNodeType() == 1) {
            nl = ((Element)node).getElementsByTagName(tagname);
        } else {
            return null;
        }
        if (nl.getLength() >= 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public static Element getElementByTagNameNS(Node node, String namespaceURI, String localName) {
        NodeList nl;
        if (node.getNodeType() == 9) {
            nl = ((Document)node).getElementsByTagNameNS(namespaceURI, localName);
        } else if (node.getNodeType() == 1) {
            nl = ((Element)node).getElementsByTagNameNS(namespaceURI, localName);
        } else {
            return null;
        }
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public static List<Element> getElementsByTagName(Node node, String tagname) {
        NodeList nl;
        ArrayList<Element> list = new ArrayList<Element>();
        if (node.getNodeType() == 9) {
            nl = ((Document)node).getElementsByTagName(tagname);
        } else if (node.getNodeType() == 1) {
            nl = ((Element)node).getElementsByTagName(tagname);
        } else {
            return null;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            list.add((Element)nl.item(i));
        }
        return list;
    }

    public static List<Element> getElementsByTagNameNS(Node node, String namespaceURI, String localName) {
        NodeList nl;
        ArrayList<Element> list = new ArrayList<Element>();
        if (node.getNodeType() == 9) {
            nl = ((Document)node).getElementsByTagNameNS(namespaceURI, localName);
        } else if (node.getNodeType() == 1) {
            nl = ((Element)node).getElementsByTagNameNS(namespaceURI, localName);
        } else {
            return null;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            list.add((Element)nl.item(i));
        }
        return list;
    }
}

