/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.index;

import com.occamlab.te.index.IndexEntry;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TemplateEntry
extends IndexEntry {
    File templateFile = null;
    boolean usesContext;
    List<QName> params = null;

    TemplateEntry() {
    }

    TemplateEntry(Element template) {
        super(template);
        try {
            String file = template.getAttribute("file");
            if (file != null && file.length() > 0) {
                this.setTemplateFile(new File(new URI(template.getAttribute("file"))));
            }
            NodeList nl = template.getElementsByTagName("param");
            this.params = new ArrayList<QName>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                String prefix = el.getAttribute("prefix");
                String namespaceUri = el.getAttribute("namespace-uri");
                String localName = el.getAttribute("local-name");
                this.params.add(new QName(namespaceUri, localName, prefix));
            }
            this.setUsesContext(Boolean.parseBoolean(template.getAttribute("uses-context")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public List<QName> getParams() {
        return this.params;
    }

    public void setParams(List<QName> params) {
        this.params = params;
    }

    public boolean usesContext() {
        return this.usesContext;
    }

    public void setUsesContext(boolean usesContext) {
        this.usesContext = usesContext;
    }
}

