/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;

public class ResolveURI
extends SystemFunction {
    String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
            if (this.expressionBaseURI == null && this.argument.length == 1) {
                XPathException de = new XPathException("Base URI in static context of resolve-uri() is unknown");
                de.setErrorCode("FONS0005");
                throw de;
            }
        }
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression copy() {
        ResolveURI d = (ResolveURI)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        return d;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        String base;
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            return null;
        }
        String relative = arg0.getStringValue();
        if (this.argument.length == 2) {
            base = this.argument[1].evaluateAsString(context).toString();
        } else {
            base = this.expressionBaseURI;
            if (this.expressionBaseURI == null) {
                this.dynamicError("Base URI in static context of resolve-uri() is unknown", "FONS0005", context);
                return null;
            }
        }
        Platform platform = Configuration.getPlatform();
        try {
            URI resolved = platform.makeAbsolute(relative, base);
            return new AnyURIValue(resolved.toString());
        }
        catch (URISyntaxException err) {
            this.dynamicError("Base URI " + Err.wrap(base) + " is invalid: " + err.getMessage(), "FORG0002", context);
            return null;
        }
    }

    public static String tryToExpand(String systemId) {
        if (systemId == null) {
            systemId = "";
        }
        try {
            new URL(systemId);
            return systemId;
        }
        catch (MalformedURLException err) {
            String dir;
            try {
                dir = System.getProperty("user.dir");
            }
            catch (Exception geterr) {
                return systemId;
            }
            if (!dir.endsWith("/") && !systemId.startsWith("/")) {
                dir = dir + '/';
            }
            try {
                URL currentDirectoryURL = new File(dir).toURL();
                URL baseURL = new URL(currentDirectoryURL, systemId);
                return baseURL.toString();
            }
            catch (MalformedURLException err2) {
                return systemId;
            }
        }
    }

    public static String escapeSpaces(String s2) {
        if (s2 == null) {
            return s2;
        }
        int i = s2.indexOf(32);
        if (i < 0) {
            return s2;
        }
        return (i == 0 ? "" : s2.substring(0, i)) + "%20" + (i == s2.length() - 1 ? "" : ResolveURI.escapeSpaces(s2.substring(i + 1)));
    }
}

