/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class ObjectValue
extends AtomicValue {
    private Object value;

    public ObjectValue() {
        this.typeLabel = BuiltInAtomicType.ANY_ATOMIC;
    }

    public ObjectValue(Object object) {
        this.value = object;
        this.typeLabel = BuiltInAtomicType.ANY_ATOMIC;
    }

    public ObjectValue(Object object, ExternalObjectType type) {
        this.value = object;
        this.typeLabel = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        ObjectValue v = new ObjectValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.typeLabel.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            if (th == null) {
                throw new NullPointerException("No TypeHierarchy supplied");
            }
            Configuration config = th.getConfiguration();
            this.typeLabel = new ExternalObjectType(this.value.getClass(), config);
        }
        return this.typeLabel;
    }

    public String displayTypeName() {
        return "java-type:" + this.value.getClass().getName();
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 285: 
            case 632: {
                return this;
            }
            case 514: {
                return BooleanValue.get(this.value != null && this.value.toString().length() > 0);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        return new StringValue(this.getStringValue()).convertPrimitive(requiredType, validate, context);
    }

    public String getStringValue() {
        return this.value == null ? "" : this.value.toString();
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value != null;
    }

    public Object getObject() {
        return this.value;
    }

    public Comparable getSchemaComparable() {
        throw new UnsupportedOperationException("External objects cannot be compared according to XML Schema rules");
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return ordered ? null : this;
    }

    public boolean equals(Object other) {
        return this.value.equals(((ObjectValue)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object convertToJava(Class target, XPathContext context) throws XPathException {
        if (this.value == null) {
            return null;
        }
        if (target.isAssignableFrom(this.value.getClass())) {
            return this.value;
        }
        if (target == Value.class || target == ObjectValue.class) {
            return this;
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            BooleanValue bval = (BooleanValue)this.convertPrimitive(BuiltInAtomicType.BOOLEAN, true, context).asAtomic();
            return bval.getBooleanValue();
        }
        if (target == String.class || target == CharSequence.class) {
            return this.getStringValue();
        }
        if (target == Double.TYPE || target == Double.class) {
            DoubleValue bval = (DoubleValue)this.convertPrimitive(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
            return new Double(bval.getDoubleValue());
        }
        if (target == Float.TYPE || target == Float.class) {
            DoubleValue bval = (DoubleValue)this.convertPrimitive(BuiltInAtomicType.FLOAT, true, context).asAtomic();
            return new Float(bval.getDoubleValue());
        }
        if (target == Long.TYPE || target == Long.class) {
            Int64Value bval = (Int64Value)this.convertPrimitive(BuiltInAtomicType.INTEGER, true, context).asAtomic();
            return new Long(bval.longValue());
        }
        if (target == Integer.TYPE || target == Integer.class) {
            Int64Value bval = (Int64Value)this.convertPrimitive(BuiltInAtomicType.INTEGER, true, context).asAtomic();
            return new Integer((int)bval.longValue());
        }
        if (target == Short.TYPE || target == Short.class) {
            Int64Value bval = (Int64Value)this.convertPrimitive(BuiltInAtomicType.INTEGER, true, context).asAtomic();
            return new Short((short)bval.longValue());
        }
        if (target == Byte.TYPE || target == Byte.class) {
            Int64Value bval = (Int64Value)this.convertPrimitive(BuiltInAtomicType.INTEGER, true, context).asAtomic();
            return new Byte((byte)bval.longValue());
        }
        if (target == Character.TYPE || target == Character.class) {
            String s2 = this.getStringValue();
            if (s2.length() == 1) {
                return new Character(s2.charAt(0));
            }
            throw new XPathException("Cannot convert string to Java char unless length is 1");
        }
        Object o = super.convertToJava(target, context);
        if (o == null) {
            throw new XPathException("Conversion of external object to " + target.getName() + " is not supported");
        }
        return o;
    }
}

