/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import org.apache.jena.JenaRuntime;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelImpl;
import org.apache.jena.vocabulary.RDF;

public class LiteralLabelFactory {
    private static final RDFDatatype dtSLangString = NodeFactory.getType(RDF.Nodes.langString.getURI());

    private static RDFDatatype fixDatatype(RDFDatatype dtype, String lang) {
        if (dtype != null) {
            return dtype;
        }
        if (JenaRuntime.isRDF11) {
            dtype = lang == null || lang.equals("") ? XSDDatatype.XSDstring : dtSLangString;
        }
        return dtype;
    }

    public static LiteralLabel create(String lex, RDFDatatype dtype) {
        return new LiteralLabelImpl(lex, "", dtype);
    }

    public static LiteralLabel createLiteralLabel(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        dtype = LiteralLabelFactory.fixDatatype(dtype, lang);
        return new LiteralLabelImpl(lex, lang, dtype);
    }

    public static LiteralLabel create(String lex, String lang) {
        RDFDatatype dt = LiteralLabelFactory.fixDatatype(null, lang);
        return new LiteralLabelImpl(lex, lang, dt);
    }

    public static LiteralLabel createByValue(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        dtype = LiteralLabelFactory.fixDatatype(dtype, lang);
        return new LiteralLabelImpl(value, lang, dtype);
    }

    @Deprecated
    public static LiteralLabel create(Object value) {
        return LiteralLabelFactory.createTypedLiteral(value);
    }

    public static LiteralLabel createTypedLiteral(Object value) {
        return new LiteralLabelImpl(value);
    }

    public static LiteralLabel create(String s2, String lang, boolean xml) {
        if (xml) {
            return new LiteralLabelImpl(s2, lang, xml);
        }
        return LiteralLabelFactory.create(s2, lang);
    }
}

