/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.SetupOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.saxon.s9api.XdmNode;

public class RuntimeOptions {
    int mode = 0;
    File testLogDir = null;
    File workDir = null;
    String sessionId = null;
    String testName = null;
    String suiteName = null;
    String sourcesName = "default";
    String baseURI = "";
    ArrayList<String> profiles = new ArrayList();
    ArrayList<String> testPaths = new ArrayList();
    ArrayList<String> params = new ArrayList();
    List<File> recordedForms = new ArrayList<File>();

    public RuntimeOptions() {
        File baseDir = SetupOptions.getBaseConfigDirectory();
        File usersDir = new File(baseDir, "users");
        File userDir = new File(usersDir, System.getProperty("user.name"));
        if (!userDir.exists()) {
            userDir.mkdirs();
        }
        this.testLogDir = userDir;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        Logger.getLogger(RuntimeOptions.class.getName()).log(Level.CONFIG, "Setting baseURI = " + baseURI);
        this.baseURI = baseURI;
    }

    public String getSourcesName() {
        return this.sourcesName;
    }

    public void setSourcesName(String sourcesName) {
        this.sourcesName = sourcesName;
    }

    public File getLogDir() {
        return this.testLogDir;
    }

    public void setLogDir(File logDir) {
        this.testLogDir = logDir;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public ArrayList<String> getProfiles() {
        return this.profiles;
    }

    public void addProfile(String profile) {
        this.profiles.add(profile);
    }

    public ArrayList<String> getTestPaths() {
        return this.testPaths;
    }

    public void addTestPath(String testPath) {
        this.testPaths.add(testPath);
    }

    public ArrayList<String> getParams() {
        return this.params;
    }

    public void addParam(String param) {
        this.params.add(param);
    }

    public XdmNode getContextNode() {
        return null;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void addRecordedForm(String recordedForm) {
        this.recordedForms.add(new File(recordedForm));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RuntimeOptions {\n");
        sb.append("mode=").append(this.mode).append(",\n");
        sb.append("testLogDir=").append(this.testLogDir).append(",\n");
        sb.append("workDir=").append(this.workDir).append(",\n");
        sb.append("sessionId=").append(this.sessionId).append(",\n");
        sb.append("testName=").append(this.testName).append(",\n");
        sb.append("suiteName=").append(this.suiteName).append(",\n");
        sb.append("sourcesName=").append(this.sourcesName).append(",\n");
        sb.append("baseURI=").append(this.baseURI).append(",\n");
        sb.append("profiles=").append(this.profiles).append(",\n");
        sb.append("testPaths=").append(this.testPaths).append(",\n");
        sb.append("recordedFroms=").append(this.recordedForms).append(",\n");
        sb.append("params=").append(this.params).append("\n}");
        return sb.toString();
    }

    public List<File> getRecordedForms() {
        return this.recordedForms;
    }
}

