/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.form;

import com.occamlab.te.util.DomUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.w3c.dom.Element;

public class ImageHandler {
    private static final Logger LOG = Logger.getLogger(ImageHandler.class.getName());
    private final File testLogDir;
    private final String sessionId;

    public ImageHandler(File testLogDir, String sessionId) {
        this.testLogDir = testLogDir;
        this.sessionId = sessionId;
    }

    public void saveImages(Element form) throws IOException {
        List<Element> images = DomUtils.getElementsByTagName(form, "img");
        int imageCount = 1;
        for (Element image : images) {
            String src;
            if (!image.hasAttribute("src") || !(src = image.getAttribute("src")).startsWith("http")) continue;
            String imageFormat = this.parseImageFormat(src);
            String imgName = this.parseImageName();
            File target = this.createImageFile(imageCount, imageFormat, imgName);
            this.saveImage(src, imageFormat, target);
            ++imageCount;
        }
    }

    private void saveImage(String src, String imageFormat, File file) {
        try {
            URL url = new URL(src);
            BufferedImage img = ImageIO.read(url);
            ImageIO.write((RenderedImage)img, imageFormat, file);
        }
        catch (Exception e) {
            LOG.warning("Could not write image " + src + " to " + file);
        }
    }

    private File createImageFile(int imageCount, String imageFormat, String imgName) {
        String downloadPath = this.testLogDir + File.separator + this.sessionId + File.separator + "images" + File.separator + imgName + imageCount + "." + imageFormat;
        File target = new File(downloadPath);
        if (!target.exists()) {
            target.getParentFile().mkdirs();
        }
        return target;
    }

    private String parseImageFormat(String src) throws MalformedURLException, UnsupportedEncodingException {
        if (src.contains("FORMAT")) {
            String[] params;
            URL url = new URL(URLDecoder.decode(src, "UTF-8"));
            for (String param : params = url.getQuery().split("&")) {
                if (!param.split("=")[0].equalsIgnoreCase("FORMAT")) continue;
                return param.split("=")[1].split("/")[1];
            }
        }
        return "PNG";
    }

    private String parseImageName() {
        String testName = System.getProperty("TestName");
        if (testName.contains(" ")) {
            return testName.substring(testName.indexOf(":") + 1, testName.indexOf(" "));
        }
        return testName;
    }
}

