/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.jaxrs.resources;

import com.occamlab.te.spi.jaxrs.ErrorResponseBuilder;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import com.occamlab.te.spi.jaxrs.TestSuiteRegistry;
import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="suites/{etsCode}/")
public class TestSuiteOverviewResource {
    @GET
    @Produces(value={"text/html; charset='utf-8'"})
    public InputStream getTestSuiteDescription(@PathParam(value="etsCode") String etsCode) {
        StringBuilder docPath = this.createPathToDoc(etsCode);
        InputStream atsStream = this.getClass().getResourceAsStream(docPath.toString());
        if (null == atsStream) {
            ErrorResponseBuilder builder = new ErrorResponseBuilder();
            Response rsp = builder.buildErrorResponse(404, "Test suite overview not found.");
            throw new WebApplicationException(rsp);
        }
        return atsStream;
    }

    private StringBuilder createPathToDoc(String etsCode) {
        StringBuilder docPath = new StringBuilder();
        docPath.append("/doc/");
        docPath.append(etsCode);
        docPath.append("/");
        docPath.append(this.findVersion(etsCode));
        docPath.append("/overview.html");
        return docPath;
    }

    private String findVersion(String code) throws WebApplicationException {
        TestSuiteRegistry registry = TestSuiteRegistry.getInstance();
        TestSuiteController controller = registry.getController(code);
        if (null == controller) {
            throw new WebApplicationException(404);
        }
        return controller.getVersion();
    }
}

