/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import com.occamlab.te.util.LogUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class DocumentationHelper {
    private String xsltSystemId;
    private File xsltFileHandler;

    public DocumentationHelper(String xslStylesheetFilePath) {
        try {
            this.xsltSystemId = new File(xslStylesheetFilePath).toURI().toURL().toExternalForm();
            this.xsltFileHandler = new File(xslStylesheetFilePath);
        }
        catch (MalformedURLException e) {
            this.xsltSystemId = "";
        }
    }

    public DocumentationHelper(URL xslStylesheetURL) {
        this.xsltSystemId = xslStylesheetURL.toExternalForm();
        try {
            this.xsltFileHandler = new File(URLDecoder.decode(xslStylesheetURL.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.xsltFileHandler = new File("");
        }
    }

    public DocumentationHelper(File xslStylesheetFile) {
        this.xsltFileHandler = xslStylesheetFile;
    }

    public void prettyPrintsReport(File logDir) throws Exception {
        if (!logDir.exists() || !logDir.isDirectory()) {
            throw new Exception("Error: LOGDIR " + logDir.getAbsolutePath() + " seems not a valid directory. ");
        }
        File html_logs_report_file = new File(logDir.getAbsolutePath() + File.separator + "report.html");
        this.prettyPrintsReport(logDir, html_logs_report_file);
    }

    private void prettyprint(String xmlLogsFile, FileOutputStream htmlReportFile) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(xmlLogsFile);
        Transformer transformer = tFactory.newTransformer(new StreamSource(this.xsltFileHandler));
        transformer.transform(new DOMSource(document), new StreamResult(htmlReportFile));
    }

    public void generateDocumentation(String sourcecodePath, String suiteName, FileOutputStream htmlFileOutput) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(false);
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(sourcecodePath);
        Transformer transformer = tFactory.newTransformer(new StreamSource(this.xsltSystemId));
        transformer.transform(new DOMSource(document), new StreamResult(htmlFileOutput));
    }

    public void generateDocumentation(String sourcecodePath, FileOutputStream htmlFileOutput) throws Exception {
        this.generateDocumentation(sourcecodePath, null, htmlFileOutput);
    }

    public void prettyPrintsReport(File sessionDir, File prettyPrintReportFile) throws Exception {
        File html_output_report_file;
        if (!sessionDir.exists() || !sessionDir.isDirectory()) {
            throw new Exception("Error: LOGDIR " + sessionDir.getAbsolutePath() + " seems not a valid directory. ");
        }
        File xml_logs_report_file = new File(sessionDir.getAbsolutePath() + File.separator + "report_logs.xml");
        if (!xml_logs_report_file.exists()) {
            System.out.println("Warning: missing logfile  " + xml_logs_report_file.getAbsolutePath() + " ! ");
            System.out.println("Trying to create it!");
            LogUtils.createFullReportLog(sessionDir.getAbsolutePath());
        }
        if ((html_output_report_file = prettyPrintReportFile).exists()) {
            System.out.println("Report file \"" + html_output_report_file.getAbsolutePath() + "\" reused!");
            return;
        }
        FileOutputStream fos = new FileOutputStream(html_output_report_file);
        this.prettyprint(xml_logs_report_file.toURI().toURL().toExternalForm(), fos);
        fos.close();
        System.out.println("Report file \"" + html_output_report_file.getAbsolutePath() + "\" created!");
    }
}

