/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public abstract class SimpleExpression
extends Expression {
    public static final Expression[] NO_ARGUMENTS = new Expression[0];
    protected Expression[] arguments = NO_ARGUMENTS;

    public void setArguments(Expression[] sub) {
        this.arguments = sub;
        for (int i = 0; i < sub.length; ++i) {
            this.adoptChildExpression(sub[i]);
        }
    }

    public Iterator iterateSubExpressions() {
        return Arrays.asList(this.arguments).iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != original) continue;
            this.arguments[i] = replacement;
            found = true;
        }
        return found;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = visitor.simplify(this.arguments[i]);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = visitor.typeCheck(this.arguments[i], contextItemType);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = visitor.optimize(this.arguments[i], contextItemType);
        }
        return this;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = this.doPromotion(this.arguments[i], offer);
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return Type.ITEM_TYPE;
    }

    public int computeCardinality() {
        if ((this.getImplementationMethod() & 1) == 0) {
            return 49152;
        }
        return 24576;
    }

    public int computeDependencies() {
        return super.computeDependencies();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        int m3 = this.getImplementationMethod();
        if ((m3 & 1) != 0) {
            throw new AssertionError((Object)("evaluateItem() is not implemented in the subclass " + this.getClass()));
        }
        if ((m3 & 2) != 0) {
            return this.iterate(context).next();
        }
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getContainer().getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        Item item = seq.getFirstItem();
        seq.reset();
        return item;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int m3 = this.getImplementationMethod();
        if ((m3 & 1) != 0) {
            Item item = this.evaluateItem(context);
            if (item == null) {
                return EmptyIterator.getInstance();
            }
            return SingletonIterator.makeIterator(item);
        }
        if ((m3 & 2) != 0) {
            throw new AssertionError((Object)("iterate() is not implemented in the subclass " + this.getClass()));
        }
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(10);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getContainer().getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        SequenceIterator result = Value.getIterator(seq.getSequence());
        seq.reset();
        return result;
    }

    public void process(XPathContext context) throws XPathException {
        int m3 = this.getImplementationMethod();
        if ((m3 & 1) == 0) {
            Item it;
            SequenceIterator iter = this.iterate(context);
            while ((it = iter.next()) != null) {
                context.getReceiver().append(it, this.locationId, 2);
            }
        } else {
            Item item = this.evaluateItem(context);
            context.getReceiver().append(item, this.locationId, 2);
        }
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("userExpression");
        destination.emitAttribute("class", this.getExpressionType());
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i].explain(destination);
        }
        destination.endElement();
    }

    public String getExpressionType() {
        return this.getClass().getName();
    }
}

