/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.atlas.lib.InternalErrorException;

public class StrUtils {
    public static final int CMP_GREATER = 1;
    public static final int CMP_EQUAL = 0;
    public static final int CMP_LESS = -1;
    public static final int CMP_UNEQUAL = -9;
    public static final int CMP_INDETERMINATE = 2;

    private StrUtils() {
    }

    public static String strjoinNL(String ... args) {
        return StrUtils.join("\n", args);
    }

    public static String strjoinNL(List<String> args) {
        return StrUtils.join("\n", args);
    }

    public static String strjoin(String sep, String ... args) {
        return StrUtils.join(sep, args);
    }

    public static String strjoin(String sep, List<String> args) {
        return StrUtils.join(sep, args);
    }

    private static String join(String sep, List<String> a) {
        return a.stream().collect(Collectors.joining(sep));
    }

    private static String join(String sep, String ... a) {
        return Arrays.stream(a).collect(Collectors.joining(sep));
    }

    public static int strCompare(String s1, String s2) {
        int x = s1.compareTo(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalErrorException("String comparison failure");
    }

    public static int strCompareIgnoreCase(String s1, String s2) {
        int x = s1.compareToIgnoreCase(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalErrorException("String comparison failure");
    }

    public static byte[] asUTF8bytes(String s2) {
        try {
            return s2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalErrorException("UTF-8 not supported!");
        }
    }

    public static String fromUTF8bytes(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalErrorException("UTF-8 not supported!");
        }
    }

    public static String str(Object x) {
        if (x == null) {
            return "<null>";
        }
        return x.toString();
    }

    public static String[] split(String s2, String splitStr) {
        return (String[])Arrays.stream(s2.split(splitStr)).map(String::trim).toArray(String[]::new);
    }

    public static final boolean contains(String str1, String str2) {
        return str1.contains(str2);
    }

    public static final String replace(String string, String target, String replacement) {
        return string.replace(target, replacement);
    }

    public static String substitute(String str, Map<String, String> subs) {
        for (Map.Entry<String, String> e : subs.entrySet()) {
            String param = e.getKey();
            if (!str.contains(param)) continue;
            str = str.replace(param, e.getValue());
        }
        return str;
    }

    public static String strform(Map<String, String> subs, String ... args) {
        return StrUtils.substitute(StrUtils.strjoinNL(args), subs);
    }

    public static String chop(String x) {
        if (x.length() == 0) {
            return x;
        }
        return x.substring(0, x.length() - 1);
    }

    public static String noNewlineEnding(String x) {
        while (x.endsWith("\n") || x.endsWith("\r")) {
            x = StrUtils.chop(x);
        }
        return x;
    }

    public static List<Character> toCharList(String str) {
        return str.codePoints().mapToObj(i -> Character.valueOf((char)i)).map(Character::new).collect(Collectors.toList());
    }

    public static String encodeHex(String str, char marker, char[] escapees) {
        char ch;
        int idx;
        int N = str.length();
        for (idx = 0; idx < N && !Chars.charInArray(ch = str.charAt(idx), escapees); ++idx) {
        }
        if (idx == N) {
            return str;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(str, 0, idx);
        while (idx < N) {
            char ch2 = str.charAt(idx);
            if (Chars.charInArray(ch2, escapees)) {
                Chars.encodeAsHex(buff, marker, ch2);
            } else {
                buff.append(ch2);
            }
            ++idx;
        }
        return buff.toString();
    }

    public static String decodeHex(String str, char marker) {
        int idx = str.indexOf(marker);
        if (idx == -1) {
            return str;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(str, 0, idx);
        int N = str.length();
        while (idx < N) {
            char ch = str.charAt(idx);
            if (ch != marker) {
                buff.append(ch);
            } else {
                char hi = str.charAt(idx + 1);
                char lo = str.charAt(idx + 2);
                char ch2 = (char)(StrUtils.hexDecode(hi) << 4 | StrUtils.hexDecode(lo));
                buff.append(ch2);
                idx += 2;
            }
            ++idx;
        }
        return buff.toString();
    }

    private static int hexDecode(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static String escapeString(String x) {
        return EscapeStr.stringEsc(x);
    }

    public static String unescapeString(String x) {
        return EscapeStr.unescapeStr(x);
    }
}

