/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class Closure
extends Value {
    protected Expression expression;
    protected XPathContextMajor savedXPathContext;
    protected int depth = 0;
    protected SequenceIterator inputIterator;

    public static Closure makeIteratorClosure(SequenceIterator iterator) {
        Closure c = new Closure();
        c.inputIterator = iterator;
        return c;
    }

    public static Value make(Expression expression, XPathContext context, int ref) throws XPathException {
        Value v = context.getConfiguration().getOptimizer().makeClosure(expression, ref, context);
        if (v instanceof Closure) {
            Closure c = (Closure)v;
            c.expression = expression;
            c.savedXPathContext = context.newContext();
            c.savedXPathContext.setOriginatingConstructType(2063);
            c.saveContext(expression, context);
            return c;
        }
        return v;
    }

    protected void saveContext(Expression expression, XPathContext context) throws XPathException {
        SequenceIterator currentIterator;
        if ((expression.getDependencies() & 0x80) != 0) {
            StackFrame localStackFrame = context.getStackFrame();
            ValueRepresentation[] local = localStackFrame.getStackFrameValues();
            int[] slotsUsed = expression.getSlotsUsed();
            if (local != null) {
                SlotManager stackFrameMap = localStackFrame.getStackFrameMap();
                ValueRepresentation[] savedStackFrame = new ValueRepresentation[stackFrameMap.getNumberOfVariables()];
                for (int s2 = 0; s2 < slotsUsed.length; ++s2) {
                    int i = slotsUsed[s2];
                    if (local[i] instanceof Closure) {
                        int cdepth = ((Closure)local[i]).depth;
                        if (cdepth >= 10) {
                            local[i] = SequenceExtent.makeSequenceExtent(((Closure)local[i]).iterate());
                        } else if (cdepth + 1 > this.depth) {
                            this.depth = cdepth + 1;
                        }
                    }
                    savedStackFrame[i] = local[i];
                }
                this.savedXPathContext.setStackFrame(stackFrameMap, savedStackFrame);
            }
        }
        if ((currentIterator = context.getCurrentIterator()) != null) {
            Item contextItem = currentIterator.current();
            UnfailingIterator single = SingletonIterator.makeIterator(contextItem);
            single.next();
            this.savedXPathContext.setCurrentIterator(single);
        }
        this.savedXPathContext.setReceiver(null);
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.expression == null) {
            return AnyItemType.getInstance();
        }
        return this.expression.getItemType(th);
    }

    public int getCardinality() {
        if (this.expression == null) {
            return 57344;
        }
        return this.expression.getCardinality();
    }

    public SequenceIterator iterate() throws XPathException {
        if (this.inputIterator == null) {
            this.inputIterator = this.expression.iterate(this.savedXPathContext);
            return this.inputIterator;
        }
        return this.inputIterator.getAnother();
    }

    public void process(XPathContext context) throws XPathException {
        if (this.expression == null) {
            Item item;
            SequenceReceiver out = context.getReceiver();
            while ((item = this.inputIterator.next()) != null) {
                out.append(item, 0, 2);
            }
            this.inputIterator = this.inputIterator.getAnother();
        } else {
            XPathContextMajor c2 = this.savedXPathContext.newContext();
            SequenceReceiver out = context.getReceiver();
            c2.setTemporaryReceiver(out);
            this.expression.process(c2);
        }
    }

    public Value reduce() throws XPathException {
        return new SequenceExtent(this.iterate()).reduce();
    }
}

