/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wms13;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestRunArguments {
    public static Properties validateArguments(Document document) {
        Object object;
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("entry");
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException("No test run arguments.");
        }
        Properties properties = new Properties();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = (Element)nodeList.item(i);
            properties.setProperty(object.getAttribute("key"), object.getTextContent().trim());
        }
        String string = properties.getProperty("capabilities-url");
        try {
            object = new URI(string);
            if (!((URI)object).isAbsolute()) {
                throw new IllegalArgumentException(String.format("Not an absolute URI: %s", object));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(String.format("Invalid URI reference: %s", string));
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException(String.format("Missing required argument: %s", "capabilities-url"));
        }
        if (null == properties.getProperty("updatesequence")) {
            properties.setProperty("updatesequence", "auto");
        }
        if (null == properties.getProperty("basic")) {
            properties.setProperty("basic", "basic");
        }
        return properties;
    }

    public static Document propertiesAsDocument(Properties properties) {
        Document document = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.storeToXML(byteArrayOutputStream, "Test run arguments");
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            Logger.getLogger(TestRunArguments.class.getName()).log(Level.WARNING, "Failed to create Document node. {0}", exception.getMessage());
        }
        return document;
    }
}

