/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ExtensionFunctionCall
extends FunctionCall {
    private transient AccessibleObject theMethod;
    private MethodRepresentation persistentMethod;
    private transient Class[] theParameterTypes;
    private Class theClass;
    private Configuration config;

    public void init(StructuredQName functionName, Class theClass, AccessibleObject object, Configuration config) {
        this.setFunctionName(functionName);
        this.theClass = theClass;
        this.theMethod = object;
        this.theParameterTypes = null;
        this.config = config;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    public Expression copy() {
        throw new UnsupportedOperationException();
    }

    public int getIntrinsicDependencies() {
        Class<?>[] theParameterTypes;
        int depend = 0x1000000;
        if (this.theMethod instanceof Method && (theParameterTypes = ((Method)this.theMethod).getParameterTypes()).length > 0 && theParameterTypes[0] == XPathContext.class) {
            depend |= 0xE;
        }
        return depend;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        ValueRepresentation[] argValues = new ValueRepresentation[this.argument.length];
        for (int i = 0; i < argValues.length; ++i) {
            argValues[i] = ExpressionTool.lazyEvaluate(this.argument[i], context, 1);
        }
        try {
            return this.call(argValues, context);
        }
        catch (XPathException err) {
            String msg = err.getMessage();
            msg = "Error in call to extension function {" + this.theMethod.toString() + "}: " + msg;
            XPathException err2 = new XPathException(msg, err.getException());
            err2.setXPathContext(context);
            err2.setLocator(this);
            err2.setErrorCode(err.getErrorCodeLocalPart());
            throw err2;
        }
    }

    public Class getTargetClass() {
        return this.theClass;
    }

    public AccessibleObject getTargetMethod() {
        return this.theMethod;
    }

    protected SequenceIterator call(ValueRepresentation[] argValues, XPathContext context) throws XPathException {
        if (this.theMethod instanceof Constructor) {
            Constructor constructor = (Constructor)this.theMethod;
            if (this.theParameterTypes == null) {
                this.theParameterTypes = constructor.getParameterTypes();
            }
            Object[] params = new Object[this.theParameterTypes.length];
            this.setupParams(argValues, params, this.theParameterTypes, 0, 0, context);
            try {
                Object result = this.invokeConstructor(constructor, params);
                return this.asIterator(result, context);
            }
            catch (InstantiationException err0) {
                throw new XPathException("Cannot instantiate class", err0);
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Constructor access is illegal", err1);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2);
            }
            catch (NullPointerException err2) {
                throw new XPathException("Object is null");
            }
            catch (InvocationTargetException err3) {
                Throwable ex = err3.getTargetException();
                if (ex instanceof XPathException) {
                    throw (XPathException)ex;
                }
                if (context.getController().isTracing() || context.getConfiguration().isTraceExternalFunctions()) {
                    err3.getTargetException().printStackTrace();
                }
                throw new XPathException("Exception in extension function: " + err3.getTargetException().toString(), ex);
            }
        }
        if (this.theMethod instanceof Method) {
            Object theInstance;
            boolean usesContext;
            Method method = (Method)this.theMethod;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            if (this.theParameterTypes == null) {
                this.theParameterTypes = method.getParameterTypes();
            }
            boolean bl = usesContext = this.theParameterTypes.length > 0 && this.theParameterTypes[0] == XPathContext.class;
            if (isStatic) {
                theInstance = null;
            } else {
                if (argValues.length == 0) {
                    throw new XPathException("Must supply an argument for a non-static extension function");
                }
                Value arg0 = Value.asValue(argValues[0]);
                theInstance = arg0.convertToJava(this.theClass, context);
            }
            Object[] params = new Object[this.theParameterTypes.length];
            if (usesContext) {
                params[0] = context;
            }
            this.setupParams(argValues, params, this.theParameterTypes, usesContext ? 1 : 0, isStatic ? 0 : 1, context);
            try {
                Object result = this.invokeMethod(method, theInstance, params);
                if (method.getReturnType() == Void.TYPE) {
                    return EmptyIterator.getInstance();
                }
                return this.asIterator(result, context);
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Method access is illegal", err1);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2);
            }
            catch (NullPointerException err2) {
                throw new XPathException("Object is null", err2);
            }
            catch (InvocationTargetException err3) {
                Throwable ex = err3.getTargetException();
                if (ex instanceof XPathException) {
                    throw (XPathException)ex;
                }
                if (context.getController().isTracing() || context.getConfiguration().isTraceExternalFunctions()) {
                    err3.getTargetException().printStackTrace();
                }
                throw new XPathException("Exception in extension function " + err3.getTargetException().toString(), ex);
            }
        }
        if (this.theMethod instanceof Field) {
            Object theInstance;
            Field field = (Field)this.theMethod;
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isStatic) {
                theInstance = null;
            } else {
                if (argValues.length == 0) {
                    throw new XPathException("Must supply an argument for a non-static extension function");
                }
                Value arg0 = Value.asValue(argValues[0]);
                theInstance = arg0.convertToJava(this.theClass, context);
            }
            try {
                Object result = this.getField(field, theInstance);
                return this.asIterator(result, context);
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Field access is illegal", err1);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2);
            }
        }
        throw new AssertionError((Object)("property " + this.theMethod + " is neither constructor, method, nor field"));
    }

    private SequenceIterator asIterator(Object result, XPathContext context) throws XPathException {
        if (result == null) {
            return EmptyIterator.getInstance();
        }
        if (result instanceof SequenceIterator) {
            return (SequenceIterator)result;
        }
        if (result instanceof Value) {
            return ((Value)result).iterate();
        }
        if (result instanceof NodeInfo) {
            return SingletonIterator.makeIterator((NodeInfo)result);
        }
        Value actual = Value.convertJavaObjectToXPath(result, SequenceType.ANY_SEQUENCE, context);
        return actual.iterate();
    }

    private void setupParams(ValueRepresentation[] argValues, Object[] params, Class[] paramTypes, int firstParam, int firstArg, XPathContext context) throws XPathException {
        int j = firstParam;
        for (int i = firstArg; i < argValues.length; ++i) {
            argValues[i] = Value.asValue(argValues[i]);
            params[j] = ((Value)argValues[i]).convertToJava(paramTypes[j], context);
            ++j;
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.convertClassToType(this.getReturnClass());
    }

    private ItemType convertClassToType(Class resultClass) {
        if (resultClass == null || resultClass == Value.class) {
            return AnyItemType.getInstance();
        }
        if (resultClass.toString().equals("void")) {
            return AnyItemType.getInstance();
        }
        if (resultClass == String.class || resultClass == StringValue.class) {
            return BuiltInAtomicType.STRING;
        }
        if (resultClass == Boolean.class || resultClass == Boolean.TYPE || resultClass == BooleanValue.class) {
            return BuiltInAtomicType.BOOLEAN;
        }
        if (resultClass == Double.class || resultClass == Double.TYPE || resultClass == DoubleValue.class) {
            return BuiltInAtomicType.DOUBLE;
        }
        if (resultClass == Float.class || resultClass == Float.TYPE || resultClass == FloatValue.class) {
            return BuiltInAtomicType.FLOAT;
        }
        if (resultClass == Long.class || resultClass == Long.TYPE || resultClass == Int64Value.class || resultClass == BigIntegerValue.class || resultClass == Integer.class || resultClass == Integer.TYPE || resultClass == Short.class || resultClass == Short.TYPE || resultClass == Byte.class || resultClass == Byte.TYPE) {
            return BuiltInAtomicType.INTEGER;
        }
        if (resultClass == BigDecimal.class) {
            return BuiltInAtomicType.DECIMAL;
        }
        if (resultClass == Date.class) {
            return BuiltInAtomicType.DATE_TIME;
        }
        if (Value.class.isAssignableFrom(resultClass) || SequenceIterator.class.isAssignableFrom(resultClass)) {
            return AnyItemType.getInstance();
        }
        List externalObjectModels = this.config.getExternalObjectModels();
        for (int m3 = 0; m3 < externalObjectModels.size(); ++m3) {
            ExternalObjectModel model = (ExternalObjectModel)externalObjectModels.get(m3);
            if (!model.isRecognizedNodeClass(resultClass) && !model.isRecognizedNodeListClass(resultClass)) continue;
            return AnyNodeTest.getInstance();
        }
        if (NodeInfo.class.isAssignableFrom(resultClass) || Source.class.isAssignableFrom(resultClass)) {
            return AnyNodeTest.getInstance();
        }
        if (List.class.isAssignableFrom(resultClass)) {
            return AnyItemType.getInstance();
        }
        if (resultClass.isArray()) {
            Class<?> component = resultClass.getComponentType();
            return this.convertClassToType(component);
        }
        if (resultClass == Object.class) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        return new ExternalObjectType(resultClass, this.config);
    }

    public int computeCardinality() {
        Class resultClass = this.getReturnClass();
        if (resultClass == null) {
            return 57344;
        }
        if (Value.class.isAssignableFrom(resultClass) || SequenceIterator.class.isAssignableFrom(resultClass) || List.class.isAssignableFrom(resultClass) || Closure.class.isAssignableFrom(resultClass) || Source.class.isAssignableFrom(resultClass) || resultClass.isArray()) {
            return 57344;
        }
        List models = this.config.getExternalObjectModels();
        for (int m3 = 0; m3 < models.size(); ++m3) {
            ExternalObjectModel model = (ExternalObjectModel)models.get(m3);
            if (model.isRecognizedNodeClass(resultClass)) {
                return 24576;
            }
            if (!model.isRecognizedNodeListClass(resultClass)) continue;
            return 57344;
        }
        if (resultClass.isPrimitive()) {
            if (resultClass.equals(Void.TYPE)) {
                return 24576;
            }
            return 16384;
        }
        return 24576;
    }

    private Class getReturnClass() {
        if (this.theMethod instanceof Method) {
            return ((Method)this.theMethod).getReturnType();
        }
        if (this.theMethod instanceof Field) {
            return ((Field)this.theMethod).getType();
        }
        if (this.theMethod instanceof Constructor) {
            return this.theClass;
        }
        return null;
    }

    protected Object invokeConstructor(Constructor constructor, Object[] params) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return constructor.newInstance(params);
    }

    protected Object invokeMethod(Method method, Object instance, Object[] params) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(instance, params);
    }

    protected Object getField(Field field, Object instance) throws IllegalAccessException {
        return field.get(instance);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        this.persistentMethod = new MethodRepresentation(this.theClass, this.theMethod);
        s2.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
            this.theMethod = this.persistentMethod.recoverAccessibleObject();
            this.theParameterTypes = null;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Cannot load a class containing extension functions used by the stylesheet: " + cnfe.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Failed to read compiled representation of extension function call to " + (this.theClass == null ? "*unknown class*" : this.theClass.getClass().getName()) + ": " + e.getMessage());
        }
    }

    public static String toCamelCase(String name, boolean debug, PrintStream diag) {
        if (name.indexOf(45) >= 0) {
            FastStringBuffer buff = new FastStringBuffer(name.length());
            boolean afterHyphen = false;
            for (int n = 0; n < name.length(); ++n) {
                char c = name.charAt(n);
                if (c == '-') {
                    afterHyphen = true;
                    continue;
                }
                if (afterHyphen) {
                    buff.append(Character.toUpperCase(c));
                } else {
                    buff.append(c);
                }
                afterHyphen = false;
            }
            name = buff.toString();
            if (debug) {
                diag.println("Seeking a method with adjusted name " + name);
            }
        }
        return name;
    }

    private static class MethodRepresentation
    implements Serializable {
        private Class theClass;
        private byte category;
        private String name;
        private Class[] params;

        public MethodRepresentation(Class theClass, AccessibleObject obj) {
            this.theClass = theClass;
            if (obj instanceof Method) {
                this.category = 0;
                this.name = ((Method)obj).getName();
                this.params = ((Method)obj).getParameterTypes();
            } else if (obj instanceof Constructor) {
                this.category = 1;
                this.params = ((Constructor)obj).getParameterTypes();
            } else {
                this.category = (byte)2;
                this.name = ((Field)obj).getName();
            }
        }

        public AccessibleObject recoverAccessibleObject() throws NoSuchMethodException, NoSuchFieldException {
            switch (this.category) {
                case 0: {
                    return this.theClass.getMethod(this.name, this.params);
                }
                case 1: {
                    return this.theClass.getConstructor(this.params);
                }
                case 2: {
                    return this.theClass.getField(this.name);
                }
            }
            return null;
        }
    }
}

