/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Err;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class Minimax
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;
    private BuiltInAtomicType argumentType = BuiltInAtomicType.ANY_ATOMIC;
    private boolean ignoreNaN = false;

    public void setIgnoreNaN(boolean ignore) {
        this.ignoreNaN = ignore;
    }

    public boolean isIgnoreNaN() {
        return this.ignoreNaN;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], false);
    }

    public int computeCardinality() {
        int c = super.computeCardinality();
        if (!Cardinality.allowsZero(this.argument[0].getCardinality())) {
            c = 16384;
        }
        return c;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int card;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.argumentType = (BuiltInAtomicType)this.argument[0].getItemType(th).getAtomizedItemType().getPrimitiveItemType();
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (this.getNumberOfArguments() == 1 && !Cardinality.allowsMany(card = this.argument[0].getCardinality()) && th.isSubType(this.argument[0].getItemType(th), BuiltInAtomicType.NUMERIC)) {
            return this.argument[0];
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType t = Atomizer.getAtomizedItemType(this.argument[0], false, th);
        if (t.getPrimitiveType() == 631) {
            return BuiltInAtomicType.DOUBLE;
        }
        return t;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        StringCollator collator = this.getCollator(1, context);
        BuiltInAtomicType type = this.argumentType;
        if (type == BuiltInAtomicType.UNTYPED_ATOMIC) {
            type = BuiltInAtomicType.DOUBLE;
        }
        AtomicComparer comparer = GenericAtomicComparer.makeAtomicComparer(type, type, collator, context);
        SequenceIterator iter = this.argument[0].iterate(context);
        try {
            return Minimax.minimax(iter, this.operation, comparer, this.ignoreNaN, context);
        }
        catch (XPathException err) {
            err.setLocator(this);
            throw err;
        }
    }

    public static AtomicValue minimax(SequenceIterator iter, int operation, AtomicComparer atomicComparer, boolean ignoreNaN, XPathContext context) throws XPathException {
        AtomicValue test;
        AtomicValue prim;
        AtomicValue min2;
        boolean foundNaN;
        boolean foundFloat;
        boolean foundDouble;
        TypeHierarchy th;
        block32: {
            block31: {
                th = context.getConfiguration().getTypeHierarchy();
                foundDouble = false;
                foundFloat = false;
                foundNaN = false;
                if (operation == 3) {
                    atomicComparer = new DescendingComparer(atomicComparer);
                }
                do {
                    if ((min2 = (AtomicValue)iter.next()) == null) {
                        return null;
                    }
                    prim = min2;
                    if (min2 instanceof UntypedAtomicValue) {
                        try {
                            prim = min2 = new DoubleValue(Value.stringToNumber(min2.getStringValueCS()));
                            foundDouble = true;
                        }
                        catch (NumberFormatException e) {
                            XPathException de = new XPathException("Failure converting " + Err.wrap(min2.getStringValueCS()) + " to a number");
                            de.setErrorCode("FORG0001");
                            de.setXPathContext(context);
                            throw de;
                        }
                    } else if (prim instanceof DoubleValue) {
                        foundDouble = true;
                    } else if (prim instanceof FloatValue) {
                        foundFloat = true;
                    }
                    if (!prim.isNaN()) break block31;
                } while (ignoreNaN);
                if (prim instanceof DoubleValue) {
                    return min2;
                }
                foundNaN = true;
                min2 = FloatValue.NaN;
                break block32;
            }
            if (!prim.getPrimitiveType().isOrdered()) {
                XPathException de = new XPathException("Type " + prim.getPrimitiveType() + " is not an ordered type");
                de.setErrorCode("FORG0006");
                de.setIsTypeError(true);
                de.setXPathContext(context);
                throw de;
            }
        }
        AtomicType lowestCommonSuperType = min2.getTypeLabel();
        while ((test = (AtomicValue)iter.next()) != null) {
            AtomicValue test2;
            prim = test2 = test;
            if (test instanceof UntypedAtomicValue) {
                try {
                    test2 = new DoubleValue(Value.stringToNumber(test.getStringValueCS()));
                    if (foundNaN) {
                        return DoubleValue.NaN;
                    }
                    prim = test2;
                    foundDouble = true;
                }
                catch (NumberFormatException e) {
                    XPathException de = new XPathException("Failure converting " + Err.wrap(test.getStringValueCS()) + " to a number");
                    de.setErrorCode("FORG0001");
                    de.setXPathContext(context);
                    throw de;
                }
            } else if (prim instanceof DoubleValue) {
                if (foundNaN) {
                    return DoubleValue.NaN;
                }
                foundDouble = true;
            } else if (prim instanceof FloatValue) {
                foundFloat = true;
            }
            lowestCommonSuperType = (AtomicType)Type.getCommonSuperType(lowestCommonSuperType, prim.getTypeLabel(), th);
            if (prim.isNaN()) {
                if (ignoreNaN) continue;
                if (foundDouble) {
                    return DoubleValue.NaN;
                }
                foundNaN = true;
                continue;
            }
            try {
                if (atomicComparer.compareAtomicValues(prim, min2) >= 0) continue;
                min2 = test2;
            }
            catch (ClassCastException err) {
                XPathException de = new XPathException("Cannot compare " + min2.getItemType(th) + " with " + test2.getItemType(th));
                de.setErrorCode("FORG0006");
                de.setIsTypeError(true);
                de.setXPathContext(context);
                throw de;
            }
        }
        if (foundNaN) {
            return FloatValue.NaN;
        }
        if (foundDouble) {
            if (!(min2 instanceof DoubleValue)) {
                min2 = min2.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
            }
        } else if (foundFloat && !(min2 instanceof FloatValue)) {
            min2 = min2.convert(BuiltInAtomicType.FLOAT, true, context).asAtomic();
        }
        return min2.convert(lowestCommonSuperType, false, context).asAtomic();
    }
}

