/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wms13;

import com.occamlab.te.SetupOptions;
import com.occamlab.te.spi.ctl.CtlExecutor;
import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.apache.commons.io.FilenameUtils;
import org.opengis.cite.wms13.TestRunArguments;
import org.w3c.dom.Document;

public class CtlController
implements TestSuiteController {
    private TestRunExecutor executor;
    private Properties etsProperties = new Properties();

    public CtlController() {
        SetupOptions setupOptions = new SetupOptions();
        try (InputStream inputStream = this.getClass().getResourceAsStream("ets.properties");){
            this.etsProperties.load(inputStream);
            String string = this.etsProperties.getProperty("main-script");
            File file = this.findScriptFile(URI.create(string));
            setupOptions.addSource(file);
            this.executor = new CtlExecutor(setupOptions);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed to initialize CtlController. {0}", iOException.getMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        File file;
        if (stringArray.length == 0) {
            file = new File(FilenameUtils.normalize(System.getProperty("user.home")), "test-run-props.xml");
        } else {
            object = stringArray[0];
            File file2 = file = ((String)object).startsWith("file:") ? new File(URI.create((String)object)) : new File((String)object);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Test run arguments not found at " + file);
        }
        object = DocumentBuilderFactory.newInstance();
        String string = "http://apache.org/xml/features/disallow-doctype-decl";
        ((DocumentBuilderFactory)object).setFeature(string, true);
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        CtlController ctlController = new CtlController();
        Source source = ctlController.doTestRun(document);
        Logger.getLogger(CtlController.class.getName()).log(Level.INFO, "Test results: {0}", source.getSystemId());
    }

    @Override
    public String getCode() {
        return this.etsProperties.getProperty("ets-code");
    }

    @Override
    public String getVersion() {
        return this.etsProperties.getProperty("ets-version");
    }

    @Override
    public String getTitle() {
        return this.etsProperties.getProperty("ets-title");
    }

    @Override
    public Source doTestRun(Document document) throws Exception {
        Properties properties = TestRunArguments.validateArguments(document);
        return this.executor.execute(TestRunArguments.propertiesAsDocument(properties));
    }

    final File findScriptFile(URI uRI) {
        Serializable serializable;
        File file = null;
        File file2 = SetupOptions.getBaseConfigDirectory();
        if (!uRI.isAbsolute()) {
            serializable = new File(file2, "scripts");
            file = new File((File)serializable, uRI.getPath());
        }
        if (null == file || !file.isFile()) {
            serializable = this.getClass().getResource(uRI.getPath());
            try {
                file = new File(((URL)serializable).toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Invalid URI: {0}", uRISyntaxException);
            }
        }
        Logger.getLogger(this.getClass().getName()).log(Level.CONFIG, "Created File object: {0}", file);
        return file;
    }
}

