/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.regex.RegexTranslator;

public abstract class SurrogateRegexTranslator
extends RegexTranslator {
    protected static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    protected static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];

    public static class Complement
    extends CharClass {
        private final CharClass cc;

        public Complement(CharClass cc) {
            super(-cc.getContainsBmp(), -cc.getContainsNonBmp());
            this.cc = cc;
        }

        public void outputBmp(FastStringBuffer buf) {
            this.cc.outputComplementBmp(buf);
        }

        public void outputComplementBmp(FastStringBuffer buf) {
            this.cc.outputBmp(buf);
        }

        public void addNonBmpRanges(List ranges) {
            ArrayList tem = new ArrayList(5);
            this.cc.addNonBmpRanges(tem);
            RegexTranslator.sortRangeList(tem);
            int c = 65536;
            int len = tem.size();
            for (int i = 0; i < len; ++i) {
                RegexTranslator.Range r = (RegexTranslator.Range)tem.get(i);
                if (r.getMin() > c) {
                    ranges.add(new RegexTranslator.Range(c, r.getMin() - 1));
                }
                c = r.getMax() + 1;
            }
            if (c != 0x110000) {
                ranges.add(new RegexTranslator.Range(c, 0x10FFFF));
            }
        }
    }

    public static class Dot
    extends CharClass {
        public Dot() {
            super(0, -1);
        }

        public void outputBmp(FastStringBuffer buf) {
            buf.append("(?:.|");
            buf.append("[\ud800-\udbff]");
            buf.append("[\udc00-\udfff]");
            buf.append(")");
        }

        public void outputComplementBmp(FastStringBuffer buf) {
            buf.append("[^\\n]");
        }

        void inClassOutputBmp(FastStringBuffer buf) {
            buf.append(".");
        }
    }

    public static class BackReference
    extends CharClass {
        private final int i;

        public BackReference(int i) {
            super(0, -1);
            this.i = i;
        }

        public void outputBmp(FastStringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        public void outputComplementBmp(FastStringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        void inClassOutputBmp(FastStringBuffer buf) {
            if (this.i != -1) {
                buf.append("(?:\\" + this.i + ")");
            } else {
                buf.append("(?:)");
            }
        }
    }

    public static class Property
    extends SimpleCharClass {
        private final String name;

        public Property(String name) {
            super(0, -1);
            this.name = name;
        }

        public void outputBmp(FastStringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        public void inClassOutputBmp(FastStringBuffer buf) {
            buf.append("\\p{");
            buf.append(this.name);
            buf.append('}');
        }

        public void outputComplementBmp(FastStringBuffer buf) {
            buf.append("\\P{");
            buf.append(this.name);
            buf.append('}');
        }
    }

    public static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        public CharRange(int lower, int upper) {
            super(lower < 65536 ? 0 : -1, upper >= 65536 ? 0 : -1);
            this.lower = lower;
            this.upper = upper;
        }

        public void inClassOutputBmp(FastStringBuffer buf) {
            if (this.lower >= 65536) {
                throw new RuntimeException("BMP output botch");
            }
            if (RegexTranslator.isJavaMetaChar((char)this.lower)) {
                buf.append('\\');
            }
            buf.append((char)this.lower);
            buf.append('-');
            if (this.upper < 65536) {
                if (RegexTranslator.isJavaMetaChar((char)this.upper)) {
                    buf.append('\\');
                }
                buf.append((char)this.upper);
            } else {
                buf.append('\uffff');
            }
        }

        public void addNonBmpRanges(List ranges) {
            if (this.upper >= 65536) {
                ranges.add(new RegexTranslator.Range(this.lower < 65536 ? 65536 : this.lower, this.upper));
            }
        }
    }

    public static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
            super(-1, -1);
        }

        public static Empty getInstance() {
            return instance;
        }

        public void inClassOutputBmp(FastStringBuffer buf) {
            throw new AssertionError((Object)"Attempt to output BMP character for empty class");
        }
    }

    public static class WideSingleChar
    extends SimpleCharClass {
        private final int c;

        public WideSingleChar(int c) {
            super(-1, 0);
            if (c <= 65535) {
                throw new IllegalArgumentException("Internal error: WideSingleChar handles non-BMP characters only");
            }
            this.c = c;
        }

        public void inClassOutputBmp(FastStringBuffer buf) {
            throw new AssertionError((Object)"WideSingleChar handles non-BMP characters only");
        }

        public int getSingleChar() {
            return this.c;
        }

        public void addNonBmpRanges(List ranges) {
            ranges.add(new RegexTranslator.Range(this.c, this.c));
        }
    }

    public static class SingleChar
    extends SimpleCharClass {
        private final char c;

        public SingleChar(char c) {
            super(0, -1);
            this.c = c;
        }

        public int getSingleChar() {
            return this.c;
        }

        public void outputBmp(FastStringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        public void inClassOutputBmp(FastStringBuffer buf) {
            if (RegexTranslator.isJavaMetaChar(this.c)) {
                buf.append('\\');
                buf.append(this.c);
            } else {
                switch (this.c) {
                    case '\r': {
                        buf.append("\\r");
                        break;
                    }
                    case '\n': {
                        buf.append("\\n");
                        break;
                    }
                    case '\t': {
                        buf.append("\\t");
                        break;
                    }
                    case ' ': {
                        buf.append("\\x20");
                        break;
                    }
                    default: {
                        buf.append(this.c);
                    }
                }
            }
        }
    }

    public static abstract class SimpleCharClass
    extends CharClass {
        public SimpleCharClass(int containsBmp, int containsNonBmp) {
            super(containsBmp, containsNonBmp);
        }

        public void outputBmp(FastStringBuffer buf) {
            buf.append('[');
            this.inClassOutputBmp(buf);
            buf.append(']');
        }

        public void outputComplementBmp(FastStringBuffer buf) {
            if (this.getContainsBmp() == -1) {
                buf.append("[\u0000-\uffff]");
            } else {
                buf.append("[^");
                this.inClassOutputBmp(buf);
                buf.append(']');
            }
        }

        public abstract void inClassOutputBmp(FastStringBuffer var1);
    }

    protected static abstract class CharClass {
        private final int containsBmp;
        private final int containsNonBmp;

        protected CharClass(int containsBmp, int containsNonBmp) {
            this.containsBmp = containsBmp;
            this.containsNonBmp = containsNonBmp;
        }

        public int getContainsBmp() {
            return this.containsBmp;
        }

        public int getContainsNonBmp() {
            return this.containsNonBmp;
        }

        public final void output(FastStringBuffer buf) {
            switch (this.containsNonBmp) {
                case -1: {
                    if (this.containsBmp == -1) {
                        buf.append("[\u0000&&[^\u0000]]");
                        break;
                    }
                    this.outputBmp(buf);
                    break;
                }
                case 1: {
                    buf.append("(?:");
                    if (this.containsBmp == -1) {
                        buf.append("[\ud800-\udbff]");
                        buf.append("[\udc00-\udfff]");
                    } else {
                        this.outputBmp(buf);
                        buf.append("[\udc00-\udfff]");
                        buf.append('?');
                    }
                    buf.append(')');
                    break;
                }
                case 0: {
                    buf.append("(?:");
                    boolean needSep = false;
                    if (this.containsBmp != -1) {
                        needSep = true;
                        this.outputBmp(buf);
                    }
                    ArrayList ranges = new ArrayList(10);
                    this.addNonBmpRanges(ranges);
                    RegexTranslator.sortRangeList(ranges);
                    String hi = RegexTranslator.highSurrogateRanges(ranges);
                    if (hi.length() > 0) {
                        if (needSep) {
                            buf.append('|');
                        } else {
                            needSep = true;
                        }
                        buf.append('[');
                        int len = hi.length();
                        for (int i = 0; i < len; i += 2) {
                            char max;
                            char min2 = hi.charAt(i);
                            if (min2 == (max = hi.charAt(i + 1))) {
                                buf.append(min2);
                                continue;
                            }
                            buf.append(min2);
                            buf.append('-');
                            buf.append(max);
                        }
                        buf.append(']');
                        buf.append("[\udc00-\udfff]");
                    }
                    String lo = RegexTranslator.lowSurrogateRanges(ranges);
                    int len = lo.length();
                    for (int i = 0; i < len; i += 3) {
                        if (needSep) {
                            buf.append('|');
                        } else {
                            needSep = true;
                        }
                        buf.append(lo.charAt(i));
                        char min3 = lo.charAt(i + 1);
                        char max = lo.charAt(i + 2);
                        if (min3 == max && (i + 3 >= len || lo.charAt(i + 3) != lo.charAt(i))) {
                            buf.append(min3);
                            continue;
                        }
                        buf.append('[');
                        while (true) {
                            if (min3 == max) {
                                buf.append(min3);
                            } else {
                                buf.append(min3);
                                buf.append('-');
                                buf.append(max);
                            }
                            if (i + 3 >= len || lo.charAt(i + 3) != lo.charAt(i)) break;
                            min3 = lo.charAt((i += 3) + 1);
                            max = lo.charAt(i + 2);
                        }
                        buf.append(']');
                    }
                    if (!needSep) {
                        buf.append("[\u0000&&[^\u0000]]");
                    }
                    buf.append(')');
                }
            }
        }

        public abstract void outputBmp(FastStringBuffer var1);

        public abstract void outputComplementBmp(FastStringBuffer var1);

        public int getSingleChar() {
            return -1;
        }

        public void addNonBmpRanges(List ranges) {
        }
    }
}

