/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.n3.turtle.TurtleReader;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.RDFReaderF;
import org.apache.jena.rdf.model.impl.NTripleReader;
import org.apache.jena.rdfxml.xmlinput.JenaReader;
import org.apache.jena.shared.ConfigException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NoReaderForLangException;

public class RDFReaderFImpl
implements RDFReaderF {
    public static final String DEFAULTLANG = "RDF/XML";
    private static Map<String, Class<? extends RDFReader>> custom = new LinkedHashMap<String, Class<? extends RDFReader>>();
    private static RDFReaderF rewiredAlternative = null;

    public static void alternative(RDFReaderF other) {
        rewiredAlternative = other;
    }

    @Override
    public RDFReader getReader() {
        return this.getReader(null);
    }

    @Override
    public RDFReader getReader(String lang) {
        if (lang == null || lang.equals("")) {
            lang = DEFAULTLANG;
        }
        if (rewiredAlternative != null) {
            return rewiredAlternative.getReader(lang);
        }
        Class<? extends RDFReader> c = custom.get(lang);
        if (c == null) {
            throw new NoReaderForLangException("Reader not found: " + lang);
        }
        try {
            return c.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JenaException(e);
        }
    }

    @Override
    @Deprecated
    public String setReaderClassName(String lang, String className) {
        return RDFReaderFImpl.setBaseReaderClassName(lang, className);
    }

    @Deprecated
    public static String setBaseReaderClassName(String lang, String className) {
        if (rewiredAlternative != null) {
            Log.fatal(RDFReaderFImpl.class, "Rewired RDFReaderFImpl - configuration changes have no effect on reading");
        }
        String oldClassName = RDFReaderFImpl.currentEntry(lang);
        try {
            Class<?> newClass = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            custom.put(lang, newClass);
            return oldClassName;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException("Reader not found on classpath", e);
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    @Override
    public void resetRDFReaderF() {
        RDFReaderFImpl.reset();
    }

    @Override
    public String removeReader(String lang) throws IllegalArgumentException {
        return RDFReaderFImpl.remove(lang);
    }

    private static void reset() {
        Class<JenaReader> rdfxmlReader = JenaReader.class;
        Class<NTripleReader> ntReader = NTripleReader.class;
        Class<TurtleReader> turtleReader = TurtleReader.class;
        custom.put("RDF", rdfxmlReader);
        custom.put(DEFAULTLANG, rdfxmlReader);
        custom.put("RDF/XML-ABBREV", rdfxmlReader);
        custom.put("N-TRIPLE", ntReader);
        custom.put("N-TRIPLES", ntReader);
        custom.put("N-Triples", ntReader);
        custom.put("N3", turtleReader);
        custom.put("TURTLE", turtleReader);
        custom.put("Turtle", turtleReader);
        custom.put("TTL", turtleReader);
    }

    private static String currentEntry(String lang) {
        Class<? extends RDFReader> oldClass = custom.get(lang);
        if (oldClass != null) {
            return oldClass.getName();
        }
        return null;
    }

    private static String remove(String lang) {
        if (rewiredAlternative != null) {
            Log.fatal(RDFReaderFImpl.class, "Rewired RDFReaderFImpl - configuration changes have no effect on reading");
        }
        String oldClassName = RDFReaderFImpl.currentEntry(lang);
        custom.remove(lang);
        return oldClassName;
    }

    static {
        RDFReaderFImpl.reset();
    }
}

