/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import com.occamlab.te.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ZipParser {
    public static final String PARSERS_NS = "http://www.occamlab.com/te/parsers";
    public static final String CTL_NS = "http://www.occamlab.com/ctl";
    public static String[][] ApplicationMediaTypeMappings = new String[][]{{"kml", "vnd.google-earth.kml+xml"}, {"kmz", "vnd.google-earth.kmz"}, {"xml", "application/xml"}, {"txt", "text/plain"}, {"jpg", "image/jpeg"}, {"jpeg", "image/jpeg"}, {"gif", "image/gif"}, {"png", "image/png"}};
    private static Logger jlogger = Logger.getLogger("com.occamlab.te.parsers.ZipParser");

    public static String getMediaType(String ext) {
        String mediaType = "";
        for (int i = 0; i < ApplicationMediaTypeMappings.length; ++i) {
            if (!ApplicationMediaTypeMappings[i][0].equals(ext.toLowerCase())) continue;
            mediaType = ApplicationMediaTypeMappings[i][1];
        }
        if (mediaType.isEmpty()) {
            mediaType = "application/octet-stream";
        }
        return mediaType;
    }

    private static Document parse(URLConnection uc, Element instruction, PrintWriter logger) throws Throwable {
        return ZipParser.parse(uc.getInputStream(), instruction, logger);
    }

    private static Document parse(InputStream is, Element instruction, PrintWriter logger) throws Throwable {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElementNS(CTL_NS, "manifest");
        ZipInputStream zis = new ZipInputStream(is);
        Document d = instruction.getOwnerDocument();
        NodeList nodes = d.getElementsByTagNameNS(CTL_NS, "SessionDir");
        Object path = "";
        if (nodes.getLength() > 0) {
            Element e = (Element)nodes.item(0);
            path = e.getTextContent();
        } else {
            path = System.getProperty("java.io.tmpdir") + "/zipparser.temp";
        }
        String randomStr = Utils.randomString(16, new Random());
        path = (String)path + "/work/" + randomStr;
        new File((String)path).mkdirs();
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            int len;
            String filename = entry.getName();
            long size = entry.getSize();
            String ext = filename.substring(filename.lastIndexOf(".") + 1);
            String mediaType = ZipParser.getMediaType(ext);
            String subdir = "";
            if (filename.lastIndexOf("/") != -1) {
                subdir = filename.substring(0, filename.lastIndexOf("/"));
            } else if (filename.lastIndexOf("\\") != -1) {
                subdir = filename.substring(0, filename.lastIndexOf("\\"));
            }
            new File((String)path, subdir).mkdirs();
            File outFile = new File((String)path, filename);
            if (!outFile.toPath().normalize().startsWith((String)path)) {
                throw new IOException("Bad zip entry");
            }
            if (outFile.isDirectory()) continue;
            FileOutputStream out = new FileOutputStream(outFile);
            byte[] buf = new byte[1024];
            while ((len = zis.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            Element fileEntry = doc.createElementNS(CTL_NS, "file-entry");
            fileEntry.setAttribute("full-path", outFile.getPath().replace('\\', '/'));
            fileEntry.setAttribute("media-type", mediaType);
            fileEntry.setAttribute("size", String.valueOf(size));
            root.appendChild(fileEntry);
        }
        doc.appendChild(root);
        return doc;
    }

    private Document saveZipFile(String filepath, Document instruction) throws Exception {
        FileInputStream is = null;
        ZipInputStream zis = null;
        try {
            is = new FileInputStream(filepath);
            zis = new ZipInputStream(is);
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "saveZipFile", e);
            System.out.println("ERROR: " + e.getMessage());
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElementNS(CTL_NS, "manifest");
        Document d = instruction.getOwnerDocument();
        NodeList nodes = d.getElementsByTagNameNS(CTL_NS, "SessionDir");
        Object path = "";
        if (nodes.getLength() > 0) {
            Element e = (Element)nodes.item(0);
            path = e.getTextContent();
        } else {
            path = System.getProperty("java.io.tmpdir") + "/zipparser.temp";
        }
        String randomStr = Utils.randomString(16, new Random());
        path = (String)path + "/work/" + randomStr;
        new File((String)path).mkdirs();
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            int len;
            System.out.println("File: " + entry.getName());
            String filename = entry.getName();
            long size = entry.getSize();
            String ext = filename.substring(filename.lastIndexOf(".") + 1);
            String mediaType = ZipParser.getMediaType(ext);
            String subdir = "";
            if (filename.lastIndexOf("/") != -1) {
                subdir = filename.substring(0, filename.lastIndexOf("/"));
            } else if (filename.lastIndexOf("\\") != -1) {
                subdir = filename.substring(0, filename.lastIndexOf("\\"));
            }
            new File((String)path, subdir).mkdirs();
            File outFile = new File((String)path, filename);
            if (!outFile.toPath().normalize().startsWith((String)path)) {
                throw new IOException("Bad zip entry");
            }
            if (outFile.isDirectory()) continue;
            FileOutputStream out = new FileOutputStream(outFile);
            byte[] buf = new byte[1024];
            while ((len = zis.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            Element fileEntry = doc.createElementNS(CTL_NS, "file-entry");
            fileEntry.setAttribute("full-path", outFile.getPath().replace('\\', '/'));
            fileEntry.setAttribute("media-type", mediaType);
            fileEntry.setAttribute("size", String.valueOf(size));
            root.appendChild(fileEntry);
        }
        zis.close();
        doc.appendChild(root);
        return doc;
    }
}

