/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.tuple;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleBase;

public class TupleN<X>
extends TupleBase<X> {
    private final X[] tuple;

    @SafeVarargs
    public static <X> TupleN<X> create(X ... xs) {
        X[] xs2 = Arrays.copyOf(xs, xs.length);
        return new TupleN<X>(xs2);
    }

    static <X> TupleN<X> wrap(X[] xs) {
        return new TupleN<X>(xs);
    }

    protected TupleN(X[] xs) {
        this.tuple = xs;
    }

    @Override
    public final X get(int i) {
        return this.tuple[i];
    }

    @Override
    public int len() {
        return this.tuple.length;
    }

    @Override
    public <Y> Tuple<Y> map(Function<X, Y> function) {
        int N2 = this.tuple.length;
        Object[] tuple2 = new Object[N2];
        for (int i = 0; i < N2; ++i) {
            tuple2[i] = function.apply(this.tuple[i]);
        }
        return TupleN.wrap(tuple2);
    }

    @Override
    public boolean contains(X item) {
        int N2 = this.tuple.length;
        for (int i = 0; i < N2; ++i) {
            if (!Objects.equals(this.tuple[i], item)) continue;
            return true;
        }
        return false;
    }
}

