/*
 * Decompiled with CFR 0.152.
 */
package org.testng.log4testng;

import java.util.Map;
import org.slf4j.LoggerFactory;
import org.testng.collections.Maps;

public class Logger {
    private static final Map<Class<?>, Logger> loggers = Maps.newConcurrentMap();
    private final org.slf4j.Logger logger;

    public static Logger getLogger(Class<?> pClass) {
        return loggers.computeIfAbsent(pClass, clz -> new Logger(LoggerFactory.getLogger(clz)));
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(Object message) {
        this.logger.trace("{}", message);
    }

    public void trace(Object message, Throwable t2) {
        this.logger.trace("{}", message, (Object)t2);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(Object message) {
        this.logger.debug("{}", message);
    }

    public void debug(Object message, Throwable t2) {
        this.logger.debug("{}", message, (Object)t2);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(Object message) {
        this.logger.info("{}", message);
    }

    public void info(Object message, Throwable t2) {
        this.logger.info("{}", message, (Object)t2);
    }

    public void warn(Object message) {
        this.logger.warn("{}", message);
    }

    public void warn(Object message, Throwable t2) {
        this.logger.warn("{}", message, (Object)t2);
    }

    public void error(Object message) {
        this.logger.error("{}", message);
    }

    public void error(Object message, Throwable t2) {
        this.logger.error("{}", message, (Object)t2);
    }

    public void fatal(Object message) {
        this.logger.error("{}", message);
    }

    public void fatal(Object message, Throwable t2) {
        this.logger.error("{}", message, (Object)t2);
    }

    private Logger(org.slf4j.Logger logger) {
        this.logger = logger;
    }
}

