/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wms13;

import com.occamlab.te.SetupOptions;
import com.occamlab.te.spi.ctl.CtlExecutor;
import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.jaxrs.TestSuiteController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.apache.commons.io.FilenameUtils;
import org.opengis.cite.wms13.TestRunArguments;
import org.w3c.dom.Document;

public class CtlController
implements TestSuiteController {
    private TestRunExecutor executor;
    private Properties etsProperties = new Properties();

    public CtlController() {
        SetupOptions setupOpts = new SetupOptions();
        try (InputStream is = this.getClass().getResourceAsStream("ets.properties");){
            this.etsProperties.load(is);
            String mainScriptPath = this.etsProperties.getProperty("main-script");
            File ctlFile = this.findScriptFile(URI.create(mainScriptPath));
            setupOpts.addSource(ctlFile);
            this.executor = new CtlExecutor(setupOpts);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed to initialize CtlController. {0}", ex.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        File propsFile;
        if (args.length == 0) {
            propsFile = new File(FilenameUtils.normalize((String)System.getProperty("user.home")), "test-run-props.xml");
        } else {
            String xmlProps = args[0];
            File file = propsFile = xmlProps.startsWith("file:") ? new File(URI.create(xmlProps)) : new File(xmlProps);
        }
        if (!propsFile.isFile()) {
            throw new IllegalArgumentException("Test run arguments not found at " + propsFile);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        dbf.setFeature(FEATURE, true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document testRunArgs = db.parse(propsFile);
        CtlController controller = new CtlController();
        Source results = controller.doTestRun(testRunArgs);
        Logger.getLogger(CtlController.class.getName()).log(Level.INFO, "Test results: {0}", results.getSystemId());
    }

    public String getCode() {
        return this.etsProperties.getProperty("ets-code");
    }

    public String getVersion() {
        return this.etsProperties.getProperty("ets-version");
    }

    public String getTitle() {
        return this.etsProperties.getProperty("ets-title");
    }

    public Source doTestRun(Document testRunArgs) throws Exception {
        Properties validArgs = TestRunArguments.validateArguments(testRunArgs);
        return this.executor.execute(TestRunArguments.propertiesAsDocument(validArgs));
    }

    final File findScriptFile(URI uri) {
        File ctlFile = null;
        File baseDir = SetupOptions.getBaseConfigDirectory();
        if (!uri.isAbsolute()) {
            File scriptsDir = new File(baseDir, "scripts");
            ctlFile = new File(scriptsDir, uri.getPath());
        }
        if (null == ctlFile || !ctlFile.isFile()) {
            URL resource = this.getClass().getResource(uri.getPath());
            try {
                ctlFile = new File(resource.toURI());
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Invalid URI: {0}", ex);
            }
        }
        Logger.getLogger(this.getClass().getName()).log(Level.CONFIG, "Created File object: {0}", ctlFile);
        return ctlFile;
    }
}

