/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.core.assertion;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.core.util.XMLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.SkipException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ETSAssert {
    private static final Logger LOGR = Logger.getLogger(ETSAssert.class.getName());

    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName qName) {
        Assert.assertEquals(node.getLocalName(), qName.getLocalPart(), ErrorMessage.get(ErrorMessageKey.LOCAL_NAME));
        Assert.assertEquals(node.getNamespaceURI(), qName.getNamespaceURI(), ErrorMessage.get(ErrorMessageKey.NAMESPACE_NAME));
    }

    public static void assertXPath(String expr, Node context, NamespaceBindings nsBindings) {
        Boolean result = ETSAssert.checkXPath(expr, context, nsBindings);
        Assert.assertTrue(result, ErrorMessage.format(ErrorMessageKey.XPATH_RESULT, context.getNodeName(), expr));
    }

    public static void verifyXPath(String expr, Node context, NamespaceBindings nsBindings, String skipMessage) {
        Boolean result = ETSAssert.checkXPath(expr, context, nsBindings);
        if (!result.booleanValue()) {
            throw new SkipException(skipMessage);
        }
    }

    public static void assertSchemaValid(Schema schema, Document document) {
        Validator validator = schema.newValidator();
        ETSAssert.assertSchemaValid(validator, new DOMSource(document, document.getDocumentURI()));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format(ErrorMessageKey.XML_ERROR, e.getMessage()));
        }
        Assert.assertFalse(errHandler.errorsDetected(), ErrorMessage.format(ErrorMessageKey.NOT_SCHEMA_VALID, errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource) {
        SchematronValidator validator;
        try {
            validator = new SchematronValidator(new StreamSource(schemaRef.toString()), "#ALL");
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        Result result = validator.validate(xmlSource);
        Assert.assertFalse(validator.ruleViolationsDetected(), ErrorMessage.format(ErrorMessageKey.NOT_SCHEMA_VALID, validator.getRuleViolationCount(), XMLUtils.resultToString(result)));
    }

    public static void assertDescendantElementCount(Document xmlEntity, QName elementName, int expectedCount) {
        NodeList features = xmlEntity.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals(features.getLength(), expectedCount, String.format("Unexpected number of %s descendant elements.", elementName));
    }

    public static void assertStatusCode(int actualCode, int ... expectedCodes) {
        Arrays.sort(expectedCodes);
        Assert.assertTrue(Arrays.binarySearch(expectedCodes, actualCode) >= 0, String.format("Expected status code(s) %s but received %d.", Arrays.toString(expectedCodes), actualCode));
    }

    public static void assertContentType(MultivaluedMap<String, String> headers, String expectedContentType) {
        List contentTypes = (List)headers.get("Content-Type");
        boolean containsContentType = ETSAssert.containsContentType(contentTypes, expectedContentType);
        String msg = String.format("Expected content type %s. but received %s", expectedContentType, ETSAssert.asString(contentTypes));
        Assert.assertTrue(containsContentType, msg);
    }

    public static void assertUrl(String url) {
        try {
            new URL(url);
            Assert.assertTrue(true);
        }
        catch (MalformedURLException e) {
            String msg = String.format("Invalid URL: %s", url);
            Assert.assertTrue(false, msg);
        }
    }

    public static void assertUriIsResolvable(String url) {
        try {
            DefaultClientConfig config = new DefaultClientConfig();
            Client client = Client.create(config);
            WebResource resource = client.resource(new URI(url));
            ClientResponse response = resource.get(ClientResponse.class);
            ETSAssert.assertStatusCode(response.getStatus(), 200);
        }
        catch (NullPointerException | URISyntaxException e) {
            String errorMsg = String.format("Invalid URI %s: %s", url, e.getMessage());
            throw new AssertionError((Object)errorMsg);
        }
    }

    public static Boolean checkXPath(String expr, Node context, NamespaceBindings nsBindings) throws AssertionError {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        LOGR.log(Level.FINE, "Evaluating \"{0}\" against context node:\n{1}", new Object[]{expr, XMLUtils.writeNodeToString(context)});
        XPathFactory factory = ETSAssert.createFactory();
        XPath xpath = factory.newXPath();
        LOGR.log(Level.FINE, "Using XPath implementation: " + xpath.getClass().getName());
        xpath.setNamespaceContext(nsBindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format(ErrorMessageKey.XPATH_ERROR, expr);
            LOGR.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        LOGR.log(Level.FINE, "XPath result: " + result);
        return result;
    }

    private static boolean containsContentType(List<String> contentTypes, String expectedContentType) {
        if (contentTypes != null) {
            for (String contentType : contentTypes) {
                if (!contentType.contains(expectedContentType)) continue;
                return true;
            }
        }
        return false;
    }

    private static String asString(List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private static XPathFactory createFactory() {
        try {
            return XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (XPathFactoryConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

